/*
 * Decompiled with CFR 0.152.
 */
package org.weixin4j.spring.web;

import java.io.IOException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.weixin4j.WeixinException;
import org.weixin4j.spi.IMessageHandler;
import org.weixin4j.util.TokenUtil;

public class WeixinJieruController {
    @Autowired
    private IMessageHandler messageHandler;

    @RequestMapping(method={RequestMethod.GET})
    public void get(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String token = TokenUtil.get();
        String echostr = request.getParameter("echostr");
        if (TokenUtil.checkSignature((String)token, (String)signature, (String)timestamp, (String)nonce)) {
            response.getWriter().write(echostr);
        }
    }

    @RequestMapping(method={RequestMethod.POST})
    public void post(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String signature = request.getParameter("signature");
        String timestamp = request.getParameter("timestamp");
        String nonce = request.getParameter("nonce");
        String token = TokenUtil.get();
        if (!TokenUtil.checkSignature((String)token, (String)signature, (String)timestamp, (String)nonce)) {
            response.getWriter().write("");
            return;
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setContentType("text/xml");
            ServletInputStream in = request.getInputStream();
            String xml = this.messageHandler.invoke(in);
            response.getWriter().write(xml);
        }
        catch (IOException e) {
            response.getWriter().write("");
        }
        catch (WeixinException ex) {
            response.getWriter().write("");
        }
    }
}

