/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.util;

import java.io.Closeable;
import java.util.NoSuchElementException;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.exceptions.JedisExhaustedPoolException;

public abstract class Pool<T>
implements Closeable {
    @Deprecated
    protected GenericObjectPool<T> internalPool;

    @Deprecated
    public Pool() {
    }

    public Pool(GenericObjectPoolConfig<T> poolConfig, PooledObjectFactory<T> factory) {
        this.initPool(poolConfig, factory);
    }

    @Override
    public void close() {
        this.destroy();
    }

    public boolean isClosed() {
        return this.internalPool.isClosed();
    }

    @Deprecated
    public void initPool(GenericObjectPoolConfig<T> poolConfig, PooledObjectFactory<T> factory) {
        if (this.internalPool != null) {
            try {
                this.closeInternalPool();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.internalPool = new GenericObjectPool(factory, poolConfig);
    }

    protected void clearInternalPool() {
        try {
            this.internalPool.clear();
        }
        catch (Exception e) {
            throw new JedisException("Could not clear the pool", e);
        }
    }

    public T getResource() {
        try {
            return (T)this.internalPool.borrowObject();
        }
        catch (NoSuchElementException nse) {
            if (null == nse.getCause()) {
                throw new JedisExhaustedPoolException("Could not get a resource since the pool is exhausted", nse);
            }
            throw new JedisException("Could not get a resource from the pool", nse);
        }
        catch (Exception e) {
            throw new JedisConnectionException("Could not get a resource from the pool", e);
        }
    }

    protected void returnResourceObject(T resource) {
        try {
            this.internalPool.returnObject(resource);
        }
        catch (Exception e) {
            throw new JedisException("Could not return the resource to the pool", e);
        }
    }

    public void returnBrokenResource(T resource) {
        if (resource != null) {
            this.returnBrokenResourceObject(resource);
        }
    }

    public void returnResource(T resource) {
        if (resource != null) {
            this.returnResourceObject(resource);
        }
    }

    public void destroy() {
        this.closeInternalPool();
    }

    protected void returnBrokenResourceObject(T resource) {
        try {
            this.internalPool.invalidateObject(resource);
        }
        catch (Exception e) {
            throw new JedisException("Could not return the broken resource to the pool", e);
        }
    }

    protected void closeInternalPool() {
        try {
            this.internalPool.close();
        }
        catch (Exception e) {
            throw new JedisException("Could not destroy the pool", e);
        }
    }

    public int getNumActive() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumActive();
    }

    public int getNumIdle() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumIdle();
    }

    public int getNumWaiters() {
        if (this.poolInactive()) {
            return -1;
        }
        return this.internalPool.getNumWaiters();
    }

    public long getMeanBorrowWaitTimeMillis() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getMeanBorrowWaitTimeMillis();
    }

    public long getMaxBorrowWaitTimeMillis() {
        if (this.poolInactive()) {
            return -1L;
        }
        return this.internalPool.getMaxBorrowWaitTimeMillis();
    }

    private boolean poolInactive() {
        return this.internalPool == null || this.internalPool.isClosed();
    }

    public void addObjects(int count) {
        try {
            for (int i = 0; i < count; ++i) {
                this.internalPool.addObject();
            }
        }
        catch (Exception e) {
            throw new JedisException("Error trying to add idle objects", e);
        }
    }
}

