/*
 * Decompiled with CFR 0.152.
 */
package net.sf.navigator.displayer;

import java.io.IOException;
import java.text.MessageFormat;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import net.sf.navigator.displayer.MenuDisplayerMapping;
import net.sf.navigator.displayer.MessageResourcesMenuDisplayer;
import net.sf.navigator.menu.MenuComponent;

public class XtreeMenuDisplayer
extends MessageResourcesMenuDisplayer {
    private static MessageFormat newWebFXTreeMessage = new MessageFormat("var {0} = new WebFXTree(''{2}'');");
    private static MessageFormat newWebFXTreeItemMessage = new MessageFormat("var {0} = new WebFXTreeItem(''{2}'');");
    private static MessageFormat newWebFXTreeItemMessage1 = new MessageFormat("var {0} = new WebFXTreeItem(''{2}'',''{3}'');");
    private static MessageFormat addMessage = new MessageFormat("{1}.add({0});");
    private static MessageFormat writeMessage = new MessageFormat("document.write({0});");
    private static String parent = "";
    private static final String END_STATEMENT_START = "document.write(";
    private static final String END_STATEMENT_END = ");";
    private static final String TAB = "    ";
    private static final String SCRIPT_START = "\n<script type=\"text/javascript\">\n<!--";
    private static final String SCRIPT_END = "//-->\n</script>\n";

    public void init(PageContext context, MenuDisplayerMapping mapping) {
        super.init(context, mapping);
        try {
            this.out.print(SCRIPT_START);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void display(MenuComponent menu) throws JspException, IOException {
        StringBuffer sb = new StringBuffer();
        this.buildMenuString(menu, sb, this.isAllowed(menu));
        this.out.print("\n    " + sb);
        this.out.print("    document.write(" + parent + END_STATEMENT_END);
    }

    public void end(PageContext context) {
        try {
            this.out.print(SCRIPT_END);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void buildMenuString(MenuComponent menu, StringBuffer sb, boolean allowed) {
        if (allowed) {
            String[] args = this.getArgs(menu);
            if (args[1] == null || args[1].equals("")) {
                sb.append(newWebFXTreeMessage.format(args) + "\n" + TAB + TAB);
                parent = args[0];
            } else if (args[3] == null || args[3].equals("")) {
                sb.append(newWebFXTreeItemMessage.format(args) + "\n" + TAB + TAB);
                sb.append(addMessage.format(args) + "\n" + TAB + TAB);
            } else {
                sb.append(newWebFXTreeItemMessage1.format(args) + "\n" + TAB + TAB);
                sb.append(addMessage.format(args) + "\n" + TAB + TAB);
            }
            MenuComponent[] subMenus = menu.getMenuComponents();
            if (subMenus.length > 0) {
                for (int i = 0; i < subMenus.length; ++i) {
                    this.buildMenuString(subMenus[i], sb, allowed ? this.isAllowed(subMenus[i]) : allowed);
                }
            }
        }
    }

    protected String[] getArgs(MenuComponent menu) {
        String[] args = new String[]{menu.getName(), this.getParentName(menu), this.getMessage(menu.getTitle()), menu.getUrl() == null ? "" : menu.getUrl()};
        return args;
    }

    protected String getParentName(MenuComponent menu) {
        String name = null;
        name = menu.getParent() == null ? "" : menu.getParent().getName();
        return name;
    }

    protected String getTarget(MenuComponent menu) {
        String theTarget = super.getTarget(menu);
        if (theTarget == null) {
            theTarget = "";
        }
        return theTarget;
    }
}

