/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.common.util;

import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class ImgWriter {
    public static boolean write(Image image, String imageType, OutputStream destImageStream, float quality) {
        if (ObjectUtils.isEmpty(imageType)) {
            imageType = "jpg";
        }
        ImageOutputStream imageOutputStream = ImgWriter.transformImageOutputStream(destImageStream);
        BufferedImage bufferedImage = CaptchaImageUtils.toBufferedImage(image, imageType);
        ImageWriter writer = ImgWriter.getWriter(bufferedImage, imageType);
        return ImgWriter.write((Image)bufferedImage, writer, imageOutputStream, quality);
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImgWriter.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static RenderedImage toRenderedImage(Image img) {
        if (img instanceof RenderedImage) {
            return (RenderedImage)((Object)img);
        }
        return CaptchaImageUtils.copyImage(img, 1);
    }

    public static ImageWriter getWriter(Image img, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(CaptchaImageUtils.toBufferedImage(img, formatName));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageOutputStream transformImageOutputStream(OutputStream out) throws RuntimeException {
        ImageOutputStream result = ImageIO.createImageOutputStream(out);
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }
}

