/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl.transform;

import cloud.tianai.captcha.generator.ImageTransform;
import cloud.tianai.captcha.generator.common.model.dto.CustomData;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.model.dto.ImageTransformData;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.generator.common.util.ImgWriter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.util.Base64;
import javax.imageio.ImageIO;

public class Base64ImageTransform
implements ImageTransform {
    public String transform(BufferedImage bufferedImage, String transformType) {
        String result = this.beforeTransform(bufferedImage, transformType);
        if (result != null) {
            return result;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (CaptchaImageUtils.isPng(transformType) || CaptchaImageUtils.isJpeg(transformType)) {
            ImgWriter.write((Image)bufferedImage, transformType, byteArrayOutputStream, -1.0f);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, transformType, byteArrayOutputStream);
        }
        byte[] data = byteArrayOutputStream.toByteArray();
        String base64 = Base64.getEncoder().encodeToString(data);
        return "data:image/" + transformType + ";base64,".concat(base64);
    }

    public String beforeTransform(BufferedImage bufferedImage, String formatType) {
        return null;
    }

    @Override
    public ImageTransformData transform(GenerateParam param, BufferedImage backgroundImage, BufferedImage templateImage, Object backgroundResource, Object templateResource, CustomData data) {
        ImageTransformData imageTransformData = new ImageTransformData();
        if (backgroundImage != null) {
            imageTransformData.setBackgroundImageUrl(this.transform(backgroundImage, param.getBackgroundFormatName()));
        }
        if (templateImage != null) {
            imageTransformData.setTemplateImageUrl(this.transform(templateImage, param.getTemplateFormatName()));
        }
        return imageTransformData;
    }
}

