/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.decoder.ObjectDecoder;
import org.redisson.client.protocol.decoder.TimeLongObjectDecoder;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.PropertiesDecoder;
import org.redisson.spring.data.connection.PropertiesListDecoder;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveServerCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.core.types.RedisClientInfo;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveServerCommands
extends RedissonBaseReactive
implements ReactiveServerCommands {
    static final RedisStrictCommand<String> BGREWRITEAOF = new RedisStrictCommand("BGREWRITEAOF");
    static final RedisStrictCommand<String> BGSAVE = new RedisStrictCommand("BGSAVE");
    static final RedisStrictCommand<String> SAVE = new RedisStrictCommand("SAVE");
    private static final RedisStrictCommand<String> FLUSHDB = new RedisStrictCommand("FLUSHDB");
    private static final RedisStrictCommand<String> FLUSHALL = new RedisStrictCommand("FLUSHALL");
    static final RedisStrictCommand<Properties> INFO_DEFAULT = new RedisStrictCommand<Object>("INFO", "DEFAULT", new ObjectDecoder<Properties>(new PropertiesDecoder()));
    static final RedisStrictCommand<Properties> INFO = new RedisStrictCommand<Object>("INFO", new ObjectDecoder<Properties>(new PropertiesDecoder()));
    static final RedisStrictCommand<Properties> CONFIG_GET = new RedisStrictCommand<Properties>("CONFIG", "GET", new PropertiesListDecoder());
    static final RedisStrictCommand<String> CONFIG_SET = new RedisStrictCommand("CONFIG", "SET");
    static final RedisStrictCommand<String> CONFIG_RESETSTAT = new RedisStrictCommand("CONFIG", "RESETSTAT");
    static final RedisStrictCommand<Long> TIME = new RedisStrictCommand<Long>("TIME", new TimeLongObjectDecoder());

    RedissonReactiveServerCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    @Override
    public Mono<String> bgReWriteAof() {
        return this.write(null, StringCodec.INSTANCE, BGREWRITEAOF, new Object[0]);
    }

    @Override
    public Mono<String> bgSave() {
        return this.write(null, StringCodec.INSTANCE, BGSAVE, new Object[0]);
    }

    @Override
    public Mono<Long> lastSave() {
        return this.write(null, StringCodec.INSTANCE, RedisCommands.LASTSAVE, new Object[0]);
    }

    @Override
    public Mono<String> save() {
        return this.write(null, StringCodec.INSTANCE, SAVE, new Object[0]);
    }

    @Override
    public Mono<Long> dbSize() {
        return this.executorService.reactive(() -> {
            List futures = this.executorService.readAllAsync(RedisCommands.DBSIZE, new Object[0]);
            CompletableFuture<Void> f = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
            CompletionStage s = f.thenApply(r -> futures.stream().mapToLong(v -> v.getNow(0L)).sum());
            return new CompletableFutureWrapper(s);
        });
    }

    @Override
    public Mono<String> flushDb() {
        return this.executorService.reactive(() -> {
            RFuture<Void> f = this.executorService.writeAllVoidAsync(FLUSHDB, new Object[0]);
            return this.toStringFuture(f);
        });
    }

    @Override
    public Mono<String> flushAll() {
        return this.executorService.reactive(() -> {
            RFuture<Void> f = this.executorService.writeAllVoidAsync(FLUSHALL, new Object[0]);
            return this.toStringFuture(f);
        });
    }

    @Override
    public Mono<String> flushDb(RedisServerCommands.FlushOption option) {
        if (option == RedisServerCommands.FlushOption.ASYNC) {
            return this.executorService.reactive(() -> {
                RFuture<Void> f = this.executorService.writeAllVoidAsync(FLUSHDB, option.toString());
                return this.toStringFuture(f);
            });
        }
        return this.flushDb();
    }

    @Override
    public Mono<String> flushAll(RedisServerCommands.FlushOption option) {
        if (option == RedisServerCommands.FlushOption.ASYNC) {
            return this.executorService.reactive(() -> {
                RFuture<Void> f = this.executorService.writeAllVoidAsync(FLUSHALL, option.toString());
                return this.toStringFuture(f);
            });
        }
        return this.flushAll();
    }

    @Override
    public Mono<Properties> info() {
        return this.read(null, StringCodec.INSTANCE, INFO_DEFAULT, new Object[0]);
    }

    @Override
    public Mono<Properties> info(String section) {
        return this.read(null, StringCodec.INSTANCE, INFO, section);
    }

    @Override
    public Mono<Properties> getConfig(String pattern) {
        return this.read(null, StringCodec.INSTANCE, CONFIG_GET, pattern);
    }

    @Override
    public Mono<String> setConfig(String param, String value) {
        return this.write(null, StringCodec.INSTANCE, CONFIG_SET, param, value);
    }

    @Override
    public Mono<String> resetConfigStats() {
        return this.write(null, StringCodec.INSTANCE, CONFIG_RESETSTAT, new Object[0]);
    }

    @Override
    public Mono<Long> time() {
        return this.read(null, LongCodec.INSTANCE, TIME, new Object[0]);
    }

    @Override
    public Mono<Long> time(final TimeUnit timeUnit) {
        return this.read(null, LongCodec.INSTANCE, new RedisStrictCommand<Long>("TIME", new TimeLongObjectDecoder(){

            @Override
            public Long decode(List<Object> parts, State state) {
                Object time = super.decode((List)parts, state);
                return timeUnit.convert((Long)time, TimeUnit.MILLISECONDS);
            }
        }), new Object[0]);
    }

    @Override
    public Mono<String> killClient(String host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Mono<String> setClientName(String name) {
        throw new UnsupportedOperationException("Should be defined through Redisson Config object");
    }

    @Override
    public Mono<String> getClientName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Flux<RedisClientInfo> getClientList() {
        throw new UnsupportedOperationException();
    }
}

