/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.PublishSubscribeService;
import org.springframework.data.redis.connection.DefaultMessage;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.SubscriptionListener;
import org.springframework.data.redis.connection.util.AbstractSubscription;

public class RedissonSubscription
extends AbstractSubscription {
    private final CommandAsyncExecutor commandExecutor;
    private final PublishSubscribeService subscribeService;

    public RedissonSubscription(CommandAsyncExecutor commandExecutor, PublishSubscribeService subscribeService, MessageListener listener) {
        super(listener, null, null);
        this.commandExecutor = commandExecutor;
        this.subscribeService = subscribeService;
    }

    @Override
    protected void doSubscribe(byte[] ... channels) {
        ArrayList<CompletableFuture<List<PubSubConnectionEntry>>> list = new ArrayList<CompletableFuture<List<PubSubConnectionEntry>>>();
        final ConcurrentLinkedQueue subscribed = new ConcurrentLinkedQueue();
        final CountDownLatch latch = new CountDownLatch(1);
        for (final byte[] channel : channels) {
            if (this.subscribeService.hasEntry(new ChannelName(channel))) continue;
            CompletableFuture<List<PubSubConnectionEntry>> f = this.subscribeService.subscribe(ByteArrayCodec.INSTANCE, new ChannelName(channel), new BaseRedisPubSubListener(){

                @Override
                public void onMessage(CharSequence ch, Object message) {
                    if (!Arrays.equals(((ChannelName)ch).getName(), channel)) {
                        return;
                    }
                    byte[] m = RedissonSubscription.this.toBytes(message);
                    DefaultMessage msg = new DefaultMessage(((ChannelName)ch).getName(), m);
                    RedissonSubscription.this.getListener().onMessage(msg, null);
                }

                @Override
                public void onStatus(PubSubType type, CharSequence ch) {
                    if (!Arrays.equals(((ChannelName)ch).getName(), channel)) {
                        return;
                    }
                    if (RedissonSubscription.this.getListener() instanceof SubscriptionListener) {
                        subscribed.add(channel);
                    }
                    super.onStatus(type, ch);
                    if (type == PubSubType.UNSUBSCRIBE) {
                        latch.countDown();
                    }
                }
            });
            list.add(f);
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            CompletableFuture future = (CompletableFuture)object.next();
            this.commandExecutor.get(future);
        }
        for (byte[] channel : subscribed) {
            ((SubscriptionListener)((Object)this.getListener())).onChannelSubscribed(channel, 1L);
        }
        if (this.getListener().getClass().getName().equals("org.springframework.data.redis.listener.SynchronizingMessageListener")) {
            StringWriter sw = new StringWriter();
            new Exception().printStackTrace(new PrintWriter(sw));
            String[] r = sw.toString().split("\n");
            if (r.length != 7) {
                return;
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected void doUnsubscribe(boolean all, byte[] ... channels) {
        for (byte[] channel : channels) {
            CompletableFuture<Codec> f = this.subscribeService.unsubscribe(new ChannelName(channel), PubSubType.UNSUBSCRIBE);
            if (!(this.getListener() instanceof SubscriptionListener)) continue;
            f.whenComplete((r, e) -> {
                if (r != null) {
                    ((SubscriptionListener)((Object)this.getListener())).onChannelUnsubscribed(channel, 1L);
                }
            });
        }
    }

    @Override
    protected void doPsubscribe(byte[] ... patterns) {
        ArrayList<CompletableFuture<Collection<PubSubConnectionEntry>>> list = new ArrayList<CompletableFuture<Collection<PubSubConnectionEntry>>>();
        final ConcurrentLinkedQueue subscribed = new ConcurrentLinkedQueue();
        final CountDownLatch latch = new CountDownLatch(1);
        for (final byte[] channel : patterns) {
            if (this.subscribeService.hasEntry(new ChannelName(channel))) continue;
            CompletableFuture<Collection<PubSubConnectionEntry>> f = this.subscribeService.psubscribe(new ChannelName(channel), ByteArrayCodec.INSTANCE, new BaseRedisPubSubListener(){

                @Override
                public void onPatternMessage(CharSequence pattern, CharSequence ch, Object message) {
                    if (!Arrays.equals(((ChannelName)pattern).getName(), channel)) {
                        return;
                    }
                    byte[] m = RedissonSubscription.this.toBytes(message);
                    DefaultMessage msg = new DefaultMessage(((ChannelName)ch).getName(), m);
                    RedissonSubscription.this.getListener().onMessage(msg, ((ChannelName)pattern).getName());
                }

                @Override
                public void onStatus(PubSubType type, CharSequence pattern) {
                    if (!Arrays.equals(((ChannelName)pattern).getName(), channel)) {
                        return;
                    }
                    if (RedissonSubscription.this.getListener() instanceof SubscriptionListener) {
                        subscribed.add(channel);
                    }
                    super.onStatus(type, pattern);
                    if (type == PubSubType.PUNSUBSCRIBE) {
                        latch.countDown();
                    }
                }
            });
            list.add(f);
        }
        Object object = list.iterator();
        while (object.hasNext()) {
            CompletableFuture future = (CompletableFuture)object.next();
            this.commandExecutor.get(future);
        }
        for (byte[] channel : subscribed) {
            ((SubscriptionListener)((Object)this.getListener())).onPatternSubscribed(channel, 1L);
        }
        if (this.getListener().getClass().getName().equals("org.springframework.data.redis.listener.SynchronizingMessageListener")) {
            StringWriter sw = new StringWriter();
            new Exception().printStackTrace(new PrintWriter(sw));
            String[] r = sw.toString().split("\n");
            if (r.length != 7) {
                return;
            }
            try {
                latch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private byte[] toBytes(Object message) {
        if (message instanceof String) {
            return ((String)message).getBytes();
        }
        return (byte[])message;
    }

    @Override
    protected void doPUnsubscribe(boolean all, byte[] ... patterns) {
        for (byte[] pattern : patterns) {
            CompletableFuture<Codec> f = this.subscribeService.unsubscribe(new ChannelName(pattern), PubSubType.PUNSUBSCRIBE);
            if (!(this.getListener() instanceof SubscriptionListener)) continue;
            f.whenComplete((r, e) -> {
                if (r != null) {
                    ((SubscriptionListener)((Object)this.getListener())).onPatternUnsubscribed(pattern, 1L);
                }
            });
        }
    }

    @Override
    protected void doClose() {
        this.doUnsubscribe(false, (byte[][])this.getChannels().toArray((T[])new byte[this.getChannels().size()][]));
        this.doPUnsubscribe(false, (byte[][])this.getPatterns().toArray((T[])new byte[this.getPatterns().size()][]));
    }
}

