/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.health;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.core.ResolvableType;
import org.springframework.util.Assert;

public abstract class AbstractCompositeHealthContributorConfiguration<C, I extends C, B> {
    private final Class<?> indicatorType;
    private final Class<?> beanType;

    AbstractCompositeHealthContributorConfiguration() {
        ResolvableType type = ResolvableType.forClass(AbstractCompositeHealthContributorConfiguration.class, this.getClass());
        this.indicatorType = type.resolveGeneric(1);
        this.beanType = type.resolveGeneric(2);
    }

    protected final C createContributor(Map<String, B> beans2) {
        Assert.notEmpty(beans2, "Beans must not be empty");
        if (beans2.size() == 1) {
            return (C)this.createIndicator(beans2.values().iterator().next());
        }
        return this.createComposite(beans2);
    }

    protected abstract C createComposite(Map<String, B> var1);

    protected I createIndicator(B bean2) {
        try {
            Constructor<?> constructor = this.indicatorType.getDeclaredConstructor(this.beanType);
            return (I)BeanUtils.instantiateClass(constructor, bean2);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to create health indicator " + this.indicatorType + " for bean type " + this.beanType, ex);
        }
    }
}

