/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.cache.impl;

import cn.hutool.cache.impl.CacheObj;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CacheObjIterator<K, V>
implements Iterator<CacheObj<K, V>> {
    private final Iterator<CacheObj<K, V>> iterator;
    private CacheObj<K, V> nextValue;

    CacheObjIterator(Iterator<CacheObj<K, V>> iterator) {
        this.iterator = iterator;
        this.nextValue();
    }

    @Override
    public boolean hasNext() {
        return this.nextValue != null;
    }

    @Override
    public CacheObj<K, V> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        CacheObj<K, V> cachedObject = this.nextValue;
        this.nextValue();
        return cachedObject;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Cache values Iterator is not support to modify.");
    }

    private void nextValue() {
        while (this.iterator.hasNext()) {
            this.nextValue = this.iterator.next();
            if (this.nextValue.isExpired()) continue;
            return;
        }
        this.nextValue = null;
    }
}

