/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.net.url;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class UrlPath {
    private List<String> segments;
    private boolean withEngTag;

    public static UrlPath of(String pathStr, Charset charset) {
        UrlPath urlPath = new UrlPath();
        urlPath.parse(pathStr, charset);
        return urlPath;
    }

    public UrlPath setWithEndTag(boolean withEngTag) {
        this.withEngTag = withEngTag;
        return this;
    }

    public List<String> getSegments() {
        return this.segments;
    }

    public String getSegment(int index) {
        if (null == this.segments || index >= this.segments.size()) {
            return null;
        }
        return this.segments.get(index);
    }

    public UrlPath add(CharSequence segment) {
        this.add(segment, false);
        return this;
    }

    public UrlPath addBefore(CharSequence segment) {
        this.add(segment, true);
        return this;
    }

    public UrlPath parse(String path, Charset charset) {
        UrlPath urlPath = new UrlPath();
        if (StrUtil.isNotEmpty(path)) {
            path = path.trim();
            StringTokenizer tokenizer = new StringTokenizer(path, "/");
            while (tokenizer.hasMoreTokens()) {
                this.add(URLUtil.decode(tokenizer.nextToken(), charset));
            }
        }
        return urlPath;
    }

    public String build(Charset charset) {
        if (CollUtil.isEmpty(this.segments)) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (String segment : this.segments) {
            builder.append('/').append(URLUtil.encodeAll(segment, charset));
        }
        if (this.withEngTag || StrUtil.isEmpty(builder)) {
            builder.append('/');
        }
        return builder.toString();
    }

    public String toString() {
        return this.build(null);
    }

    private void add(CharSequence segment, boolean before) {
        String seg = UrlPath.fixSegment(segment);
        if (null == seg) {
            return;
        }
        if (this.segments == null) {
            this.segments = new LinkedList<String>();
        }
        if (before) {
            this.segments.add(0, seg);
        } else {
            this.segments.add(seg);
        }
    }

    private static String fixSegment(CharSequence segment) {
        if (StrUtil.isEmpty(segment) || "/".contentEquals(segment)) {
            return null;
        }
        String segmentStr = StrUtil.str(segment);
        segmentStr = StrUtil.trim(segmentStr);
        segmentStr = StrUtil.removePrefix(segmentStr, "/");
        segmentStr = StrUtil.removeSuffix(segmentStr, "/");
        segmentStr = StrUtil.trim(segmentStr);
        return segmentStr;
    }
}

