/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push;

import cn.jiguang.common.ClientConfig;
import cn.jiguang.common.ServiceHelper;
import cn.jiguang.common.connection.HttpProxy;
import cn.jiguang.common.connection.IHttpClient;
import cn.jiguang.common.connection.NativeHttpClient;
import cn.jiguang.common.resp.APIConnectionException;
import cn.jiguang.common.resp.APIRequestException;
import cn.jiguang.common.resp.ResponseWrapper;
import cn.jiguang.common.utils.Base64;
import cn.jiguang.common.utils.Preconditions;
import cn.jiguang.common.utils.sm2.SM2Util;
import cn.jpush.api.push.PushResult;
import cn.jpush.api.push.model.EncryptKeys;
import cn.jpush.api.push.model.EncryptPushPayload;
import cn.jpush.api.push.model.PushPayload;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.Map;

public class GroupPushClient {
    private IHttpClient _httpClient;
    private String _baseUrl;
    private String _groupPushPath;
    private String _encryptType;
    private Gson _gson = new Gson();

    public GroupPushClient(String groupMasterSecret, String groupKey) {
        this(groupMasterSecret, groupKey, null, ClientConfig.getInstance());
    }

    public GroupPushClient(String groupMasterSecret, String groupKey, HttpProxy proxy, ClientConfig conf) {
        ServiceHelper.checkBasic((String)groupKey, (String)groupMasterSecret);
        this._baseUrl = (String)conf.get((Object)"push.host.name");
        this._groupPushPath = (String)conf.get((Object)"group.push.path");
        this._encryptType = (String)conf.get((Object)"encrypt.type");
        String authCode = ServiceHelper.getBasicAuthorization((String)("group-" + groupKey), (String)groupMasterSecret);
        this._httpClient = new NativeHttpClient(authCode, proxy, conf);
    }

    public Map<String, PushResult> sendGroupPush(PushPayload pushPayload) throws APIConnectionException, APIRequestException {
        Preconditions.checkArgument((null != pushPayload ? 1 : 0) != 0, (Object)"pushPayload should not be null");
        ResponseWrapper response = this._httpClient.sendPost(this._baseUrl + this._groupPushPath, this.getEncryptData(pushPayload));
        return (Map)this._gson.fromJson(response.responseContent, new TypeToken<Map<String, PushResult>>(){}.getType());
    }

    private String getEncryptData(PushPayload pushPayload) {
        if (this._encryptType.isEmpty()) {
            return pushPayload.toString();
        }
        if (EncryptKeys.ENCRYPT_SMS2_TYPE.equals(this._encryptType)) {
            EncryptPushPayload encryptPushPayload = new EncryptPushPayload();
            try {
                encryptPushPayload.setPayload(String.valueOf(Base64.encode((byte[])SM2Util.encrypt((String)pushPayload.toString(), (String)EncryptKeys.DEFAULT_SM2_ENCRYPT_KEY))));
            }
            catch (Exception e) {
                throw new RuntimeException("encrypt word exception", e);
            }
            encryptPushPayload.setAudience(pushPayload.getAudience());
            return encryptPushPayload.toString();
        }
        return pushPayload.toString();
    }
}

