/*
 * Decompiled with CFR 0.152.
 */
package cn.stylefeng.roses.kernel.file.modular.factory;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.stylefeng.roses.kernel.file.FileOperatorApi;
import cn.stylefeng.roses.kernel.file.enums.FileLocationEnum;
import cn.stylefeng.roses.kernel.file.enums.FileStatusEnum;
import cn.stylefeng.roses.kernel.file.exception.FileException;
import cn.stylefeng.roses.kernel.file.exception.enums.FileExceptionEnum;
import cn.stylefeng.roses.kernel.file.modular.entity.SysFileInfo;
import cn.stylefeng.roses.kernel.file.pojo.request.SysFileInfoRequest;
import cn.stylefeng.roses.kernel.rule.exception.AbstractExceptionEnum;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.io.IOException;
import java.math.BigDecimal;
import org.springframework.web.multipart.MultipartFile;

public class FileInfoFactory {
    public static SysFileInfo createSysFileInfo(MultipartFile file, SysFileInfoRequest sysFileInfoRequest) {
        FileOperatorApi fileOperatorApi = (FileOperatorApi)SpringUtil.getBean(FileOperatorApi.class);
        Long fileId = IdWorker.getId();
        String originalFilename = file.getOriginalFilename();
        String fileSuffix = null;
        if (ObjectUtil.isNotEmpty((Object)originalFilename)) {
            fileSuffix = StrUtil.subAfter((CharSequence)originalFilename, (CharSequence)".", (boolean)true);
        }
        String finalFileName = fileId + "." + fileSuffix;
        try {
            byte[] bytes = file.getBytes();
            fileOperatorApi.storageFile("defaultBucket", finalFileName, bytes);
        }
        catch (IOException e) {
            throw new FileException((AbstractExceptionEnum)FileExceptionEnum.ERROR_FILE, new Object[]{e.getMessage()});
        }
        long fileSizeKb = Convert.toLong((Object)NumberUtil.div((Number)new BigDecimal(file.getSize()), (Number)BigDecimal.valueOf(1024L)).setScale(0, 4));
        String fileSizeInfo = FileUtil.readableFileSize((long)file.getSize());
        SysFileInfo sysFileInfo = new SysFileInfo();
        sysFileInfo.setFileLocation(FileLocationEnum.LOCAL.getCode());
        sysFileInfo.setFileBucket("defaultBucket");
        sysFileInfo.setFileObjectName(finalFileName);
        sysFileInfo.setFileOriginName(originalFilename);
        sysFileInfo.setFileSuffix(fileSuffix);
        sysFileInfo.setFileSizeKb(fileSizeKb);
        sysFileInfo.setFileSizeInfo(fileSizeInfo);
        sysFileInfo.setFileStatus(FileStatusEnum.NEW.getCode());
        sysFileInfo.setSecretFlag(sysFileInfoRequest.getSecretFlag());
        return sysFileInfo;
    }
}

