/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class MetricAggregationBase
implements JsonpSerializable {
    @Nullable
    private final String field;
    @Nullable
    private final FieldValue missing;
    @Nullable
    private final Script script;

    protected MetricAggregationBase(AbstractBuilder<?> builder) {
        this.field = ((AbstractBuilder)builder).field;
        this.missing = ((AbstractBuilder)builder).missing;
        this.script = ((AbstractBuilder)builder).script;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Nullable
    public final Script script() {
        return this.script;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (this.script != null) {
            generator.writeKey("script");
            this.script.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMetricAggregationBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(AbstractBuilder::missing, FieldValue._DESERIALIZER, "missing");
        op.add(AbstractBuilder::script, Script._DESERIALIZER, "script");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        @Nullable
        private String field;
        @Nullable
        private FieldValue missing;
        @Nullable
        private Script script;

        protected AbstractBuilder() {
        }

        public final BuilderT field(@Nullable String value) {
            this.field = value;
            return (BuilderT)this.self();
        }

        public final BuilderT missing(@Nullable FieldValue value) {
            this.missing = value;
            return (BuilderT)this.self();
        }

        public final BuilderT missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        public final BuilderT missing(String value) {
            this.missing = FieldValue.of(value);
            return (BuilderT)this.self();
        }

        public final BuilderT missing(long value) {
            this.missing = FieldValue.of(value);
            return (BuilderT)this.self();
        }

        public final BuilderT missing(double value) {
            this.missing = FieldValue.of(value);
            return (BuilderT)this.self();
        }

        public final BuilderT missing(boolean value) {
            this.missing = FieldValue.of(value);
            return (BuilderT)this.self();
        }

        public final BuilderT script(@Nullable Script value) {
            this.script = value;
            return (BuilderT)this.self();
        }

        public final BuilderT script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }
}

