/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.security.auth.defaults.signer;

import com.alibaba.ageiport.security.URLEncoder;
import com.alibaba.ageiport.security.auth.Credentials;
import com.alibaba.ageiport.security.auth.Signer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class HmacSHA256
implements Signer {
    private static final String ALGORITHM_NAME = "HmacSHA256";

    public String getName() {
        return ALGORITHM_NAME;
    }

    public String getVersion() {
        return "1.0";
    }

    public String signString(String stringToSign, Credentials credentials) {
        try {
            String accessKeySecret = credentials.getAccessKeySecret();
            Mac sha256_HMAC = Mac.getInstance(ALGORITHM_NAME);
            SecretKeySpec secret_key = new SecretKeySpec(accessKeySecret.getBytes(), ALGORITHM_NAME);
            sha256_HMAC.init(secret_key);
            return URLEncoder.hexEncode((byte[])sha256_HMAC.doFinal(stringToSign.getBytes()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException(e.toString());
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public boolean verify(String stringToSign, String sign, Credentials credentials) {
        return true;
    }

    public String getAuthorization(Credentials credentials, String sign) {
        return this.getName() + " Credential=" + credentials.getAccessKeyId() + ",Signature=" + sign;
    }
}

