/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.api;

import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinitionChangeObserver;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.spi.SpiLoader;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class GatewayApiDefinitionManager {
    private static final Map<String, ApiDefinition> API_MAP = new ConcurrentHashMap<String, ApiDefinition>();
    private static final ApiDefinitionPropertyListener LISTENER = new ApiDefinitionPropertyListener();
    private static SentinelProperty<Set<ApiDefinition>> currentProperty = new DynamicSentinelProperty();
    private static final Map<String, ApiDefinitionChangeObserver> API_CHANGE_OBSERVERS = new ConcurrentHashMap<String, ApiDefinitionChangeObserver>();

    private static void initializeApiChangeObserverSpi() {
        List listeners = SpiLoader.of(ApiDefinitionChangeObserver.class).loadInstanceList();
        for (ApiDefinitionChangeObserver e : listeners) {
            API_CHANGE_OBSERVERS.put(e.getClass().getCanonicalName(), e);
            RecordLog.info((String)"[GatewayApiDefinitionManager] ApiDefinitionChangeObserver added: {}", (Object[])new Object[]{e.getClass().getCanonicalName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<Set<ApiDefinition>> property) {
        AssertUtil.notNull(property, (String)"property cannot be null");
        ApiDefinitionPropertyListener apiDefinitionPropertyListener = LISTENER;
        synchronized (apiDefinitionPropertyListener) {
            RecordLog.info((String)"[GatewayApiDefinitionManager] Registering new property to gateway API definition manager", (Object[])new Object[0]);
            currentProperty.removeListener((PropertyListener)LISTENER);
            property.addListener((PropertyListener)LISTENER);
            currentProperty = property;
        }
    }

    public static boolean loadApiDefinitions(Set<ApiDefinition> apiDefinitions) {
        return currentProperty.updateValue(apiDefinitions);
    }

    public static ApiDefinition getApiDefinition(String apiName) {
        if (apiName == null) {
            return null;
        }
        return API_MAP.get(apiName);
    }

    public static Set<ApiDefinition> getApiDefinitions() {
        return new HashSet<ApiDefinition>(API_MAP.values());
    }

    private static void notifyDownstreamListeners(Set<ApiDefinition> definitions) {
        try {
            for (Map.Entry<String, ApiDefinitionChangeObserver> entry : API_CHANGE_OBSERVERS.entrySet()) {
                entry.getValue().onChange(definitions);
            }
        }
        catch (Exception ex) {
            RecordLog.warn((String)"[GatewayApiDefinitionManager] WARN: failed to notify downstream api listeners", (Throwable)ex);
        }
    }

    public static boolean isValidApi(ApiDefinition apiDefinition) {
        return apiDefinition != null && StringUtil.isNotBlank((String)apiDefinition.getApiName()) && apiDefinition.getPredicateItems() != null;
    }

    static void addApiChangeListener(ApiDefinitionChangeObserver listener) {
        AssertUtil.notNull((Object)listener, (String)"listener cannot be null");
        API_CHANGE_OBSERVERS.put(listener.getClass().getCanonicalName(), listener);
    }

    static void removeApiChangeListener(Class<?> clazz) {
        AssertUtil.notNull(clazz, (String)"class cannot be null");
        API_CHANGE_OBSERVERS.remove(clazz.getCanonicalName());
    }

    static {
        try {
            currentProperty.addListener((PropertyListener)LISTENER);
            GatewayApiDefinitionManager.initializeApiChangeObserverSpi();
        }
        catch (Throwable ex) {
            RecordLog.warn((String)"[GatewayApiDefinitionManager] Failed to initialize", (Throwable)ex);
            ex.printStackTrace();
        }
    }

    private static final class ApiDefinitionPropertyListener
    implements PropertyListener<Set<ApiDefinition>> {
        private ApiDefinitionPropertyListener() {
        }

        public void configUpdate(Set<ApiDefinition> set) {
            ApiDefinitionPropertyListener.applyApiUpdateInternal(set);
            RecordLog.info((String)"[GatewayApiDefinitionManager] Api definition updated: {}", (Object[])new Object[]{API_MAP});
        }

        public void configLoad(Set<ApiDefinition> set) {
            ApiDefinitionPropertyListener.applyApiUpdateInternal(set);
            RecordLog.info((String)"[GatewayApiDefinitionManager] Api definition loaded: {}", (Object[])new Object[]{API_MAP});
        }

        private static synchronized void applyApiUpdateInternal(Set<ApiDefinition> set) {
            if (set == null || set.isEmpty()) {
                API_MAP.clear();
                GatewayApiDefinitionManager.notifyDownstreamListeners(new HashSet());
                return;
            }
            HashMap<String, ApiDefinition> map = new HashMap<String, ApiDefinition>(set.size());
            HashSet<ApiDefinition> validSet = new HashSet<ApiDefinition>();
            for (ApiDefinition definition : set) {
                if (!GatewayApiDefinitionManager.isValidApi(definition)) continue;
                map.put(definition.getApiName(), definition);
                validSet.add(definition);
            }
            API_MAP.clear();
            API_MAP.putAll(map);
            GatewayApiDefinitionManager.notifyDownstreamListeners(validSet);
        }
    }
}

