/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dashscope.aigc.imagesynthesis;

import com.alibaba.dashscope.base.HalfDuplexServiceParam;
import com.alibaba.dashscope.exception.InputRequiredException;
import com.alibaba.dashscope.utils.JsonUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;

public class ImageSynthesisParam
extends HalfDuplexServiceParam {
    private Integer n;
    private String size;
    private Integer steps;
    private Integer scale;
    @NonNull
    private String prompt;
    private String negativePrompt;

    public JsonObject getInput() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("prompt", this.prompt);
        if (this.negativePrompt != null && !this.negativePrompt.isEmpty()) {
            jsonObject.addProperty("negative_prompt", this.negativePrompt);
        }
        return jsonObject;
    }

    @Override
    public Map<String, Object> getParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.n != null) {
            params.put("n", this.n);
        }
        if (this.size != null) {
            params.put("size", this.size);
        }
        if (this.negativePrompt != null) {
            params.put("negative_prompt", this.negativePrompt);
        }
        if (this.steps != null) {
            params.put("steps", this.steps);
        }
        if (this.scale != null) {
            params.put("scale", this.scale);
        }
        params.putAll(super.getParameters());
        return params;
    }

    @Override
    public JsonObject getHttpBody() {
        JsonObject body = new JsonObject();
        body.addProperty("model", this.getModel());
        body.add("input", (JsonElement)this.getInput());
        if (this.getParameters() != null) {
            body.add("parameters", (JsonElement)JsonUtils.parametersToJsonObject(this.getParameters()));
        }
        return body;
    }

    @Override
    public ByteBuffer getBinaryData() {
        throw new UnsupportedOperationException("Unimplemented method 'getBinaryData'");
    }

    @Override
    public void validate() throws InputRequiredException {
    }

    private static Integer $default$n() {
        return null;
    }

    private static String $default$size() {
        return null;
    }

    private static Integer $default$steps() {
        return null;
    }

    private static Integer $default$scale() {
        return null;
    }

    protected ImageSynthesisParam(ImageSynthesisParamBuilder<?, ?> b) {
        super((HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<?, ?>)b);
        this.n = ((ImageSynthesisParamBuilder)b).n$set ? ((ImageSynthesisParamBuilder)b).n$value : ImageSynthesisParam.$default$n();
        this.size = ((ImageSynthesisParamBuilder)b).size$set ? ((ImageSynthesisParamBuilder)b).size$value : ImageSynthesisParam.$default$size();
        this.steps = ((ImageSynthesisParamBuilder)b).steps$set ? ((ImageSynthesisParamBuilder)b).steps$value : ImageSynthesisParam.$default$steps();
        this.scale = ((ImageSynthesisParamBuilder)b).scale$set ? ((ImageSynthesisParamBuilder)b).scale$value : ImageSynthesisParam.$default$scale();
        this.prompt = ((ImageSynthesisParamBuilder)b).prompt;
        if (this.prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.negativePrompt = ((ImageSynthesisParamBuilder)b).negativePrompt;
    }

    public static ImageSynthesisParamBuilder<?, ?> builder() {
        return new ImageSynthesisParamBuilderImpl();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageSynthesisParam)) {
            return false;
        }
        ImageSynthesisParam other = (ImageSynthesisParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$n = this.getN();
        Integer other$n = other.getN();
        if (this$n == null ? other$n != null : !((Object)this$n).equals(other$n)) {
            return false;
        }
        Integer this$steps = this.getSteps();
        Integer other$steps = other.getSteps();
        if (this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps)) {
            return false;
        }
        Integer this$scale = this.getScale();
        Integer other$scale = other.getScale();
        if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$prompt = this.getPrompt();
        String other$prompt = other.getPrompt();
        if (this$prompt == null ? other$prompt != null : !this$prompt.equals(other$prompt)) {
            return false;
        }
        String this$negativePrompt = this.getNegativePrompt();
        String other$negativePrompt = other.getNegativePrompt();
        return !(this$negativePrompt == null ? other$negativePrompt != null : !this$negativePrompt.equals(other$negativePrompt));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ImageSynthesisParam;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $n = this.getN();
        result = result * 59 + ($n == null ? 43 : ((Object)$n).hashCode());
        Integer $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        Integer $scale = this.getScale();
        result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $prompt = this.getPrompt();
        result = result * 59 + ($prompt == null ? 43 : $prompt.hashCode());
        String $negativePrompt = this.getNegativePrompt();
        result = result * 59 + ($negativePrompt == null ? 43 : $negativePrompt.hashCode());
        return result;
    }

    public Integer getN() {
        return this.n;
    }

    public String getSize() {
        return this.size;
    }

    public Integer getSteps() {
        return this.steps;
    }

    public Integer getScale() {
        return this.scale;
    }

    @NonNull
    public String getPrompt() {
        return this.prompt;
    }

    public String getNegativePrompt() {
        return this.negativePrompt;
    }

    public void setN(Integer n) {
        this.n = n;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public void setSteps(Integer steps) {
        this.steps = steps;
    }

    public void setScale(Integer scale) {
        this.scale = scale;
    }

    public void setPrompt(@NonNull String prompt) {
        if (prompt == null) {
            throw new NullPointerException("prompt is marked non-null but is null");
        }
        this.prompt = prompt;
    }

    public void setNegativePrompt(String negativePrompt) {
        this.negativePrompt = negativePrompt;
    }

    @Override
    public String toString() {
        return "ImageSynthesisParam(n=" + this.getN() + ", size=" + this.getSize() + ", steps=" + this.getSteps() + ", scale=" + this.getScale() + ", prompt=" + this.getPrompt() + ", negativePrompt=" + this.getNegativePrompt() + ")";
    }

    private static final class ImageSynthesisParamBuilderImpl
    extends ImageSynthesisParamBuilder<ImageSynthesisParam, ImageSynthesisParamBuilderImpl> {
        private ImageSynthesisParamBuilderImpl() {
        }

        @Override
        protected ImageSynthesisParamBuilderImpl self() {
            return this;
        }

        @Override
        public ImageSynthesisParam build() {
            return new ImageSynthesisParam(this);
        }
    }

    public static abstract class ImageSynthesisParamBuilder<C extends ImageSynthesisParam, B extends ImageSynthesisParamBuilder<C, B>>
    extends HalfDuplexServiceParam.HalfDuplexServiceParamBuilder<C, B> {
        private boolean n$set;
        private Integer n$value;
        private boolean size$set;
        private String size$value;
        private boolean steps$set;
        private Integer steps$value;
        private boolean scale$set;
        private Integer scale$value;
        private String prompt;
        private String negativePrompt;

        public B n(Integer n) {
            this.n$value = n;
            this.n$set = true;
            return (B)this.self();
        }

        public B size(String size) {
            this.size$value = size;
            this.size$set = true;
            return (B)this.self();
        }

        public B steps(Integer steps) {
            this.steps$value = steps;
            this.steps$set = true;
            return (B)this.self();
        }

        public B scale(Integer scale) {
            this.scale$value = scale;
            this.scale$set = true;
            return (B)this.self();
        }

        public B prompt(@NonNull String prompt) {
            if (prompt == null) {
                throw new NullPointerException("prompt is marked non-null but is null");
            }
            this.prompt = prompt;
            return (B)this.self();
        }

        public B negativePrompt(String negativePrompt) {
            this.negativePrompt = negativePrompt;
            return (B)this.self();
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @Override
        public String toString() {
            return "ImageSynthesisParam.ImageSynthesisParamBuilder(super=" + super.toString() + ", n$value=" + this.n$value + ", size$value=" + this.size$value + ", steps$value=" + this.steps$value + ", scale$value=" + this.scale$value + ", prompt=" + this.prompt + ", negativePrompt=" + this.negativePrompt + ")";
        }
    }
}

