/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.config.impl;

import com.alibaba.nacos.client.identify.Base64;
import com.alibaba.nacos.client.identify.CredentialService;
import com.alibaba.nacos.common.utils.StringUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class SpasAdapter {
    private static final String GROUP_KEY = "group";
    public static final String TENANT_KEY = "tenant";

    public static List<String> getSignHeaders(String resource, String secretKey) {
        ArrayList<String> header = new ArrayList<String>();
        String timeStamp = String.valueOf(System.currentTimeMillis());
        header.add("Timestamp");
        header.add(timeStamp);
        if (secretKey != null) {
            header.add("Spas-Signature");
            String signature = "";
            signature = StringUtils.isBlank((String)resource) ? SpasAdapter.signWithHmacSha1Encrypt(timeStamp, secretKey) : SpasAdapter.signWithHmacSha1Encrypt(resource + "+" + timeStamp, secretKey);
            header.add(signature);
        }
        return header;
    }

    public static List<String> getSignHeaders(List<String> paramValues, String secretKey) {
        if (null == paramValues) {
            return null;
        }
        HashMap<String, String> signMap = new HashMap<String, String>(5);
        Iterator<String> iter = paramValues.iterator();
        while (iter.hasNext()) {
            String key = iter.next();
            if (TENANT_KEY.equals(key) || GROUP_KEY.equals(key)) {
                signMap.put(key, iter.next());
                continue;
            }
            iter.next();
        }
        String resource = "";
        if (signMap.size() > 1) {
            resource = (String)signMap.get(TENANT_KEY) + "+" + (String)signMap.get(GROUP_KEY);
        } else if (!StringUtils.isBlank((String)((String)signMap.get(GROUP_KEY)))) {
            resource = (String)signMap.get(GROUP_KEY);
        }
        return SpasAdapter.getSignHeaders(resource, secretKey);
    }

    public static String getSk() {
        return CredentialService.getInstance().getCredential().getSecretKey();
    }

    public static String getAk() {
        return CredentialService.getInstance().getCredential().getAccessKey();
    }

    public static String signWithHmacSha1Encrypt(String encryptText, String encryptKey) {
        try {
            byte[] data = encryptKey.getBytes(StandardCharsets.UTF_8);
            SecretKeySpec secretKey = new SecretKeySpec(data, "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(secretKey);
            byte[] text = encryptText.getBytes(StandardCharsets.UTF_8);
            byte[] textFinal = mac.doFinal(text);
            return new String(Base64.encodeBase64(textFinal), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("signWithhmacSHA1Encrypt fail", e);
        }
    }
}

