/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.net;

import com.alibaba.nacos.common.http.AbstractHttpClientFactory;
import com.alibaba.nacos.common.http.HttpClientBeanHolder;
import com.alibaba.nacos.common.http.HttpClientConfig;
import com.alibaba.nacos.common.http.HttpClientFactory;
import com.alibaba.nacos.common.http.client.NacosRestTemplate;

public class NamingHttpClientManager {
    private static final int READ_TIME_OUT_MILLIS = Integer.getInteger("com.alibaba.nacos.client.naming.rtimeout", 50000);
    private static final int CON_TIME_OUT_MILLIS = Integer.getInteger("com.alibaba.nacos.client.naming.ctimeout", 3000);
    private static final boolean ENABLE_HTTPS = Boolean.getBoolean("com.alibaba.nacos.client.naming.tls.enable");
    private static final int MAX_REDIRECTS = 5;
    private static final HttpClientFactory HTTP_CLIENT_FACTORY = new NamingHttpClientFactory();

    public static String getPrefix() {
        if (ENABLE_HTTPS) {
            return "https://";
        }
        return "http://";
    }

    public static NacosRestTemplate getNacosRestTemplate() {
        return HttpClientBeanHolder.getNacosRestTemplate((HttpClientFactory)HTTP_CLIENT_FACTORY);
    }

    private static class NamingHttpClientFactory
    extends AbstractHttpClientFactory {
        private NamingHttpClientFactory() {
        }

        protected HttpClientConfig buildHttpClientConfig() {
            return HttpClientConfig.builder().setConTimeOutMillis(CON_TIME_OUT_MILLIS).setReadTimeOutMillis(READ_TIME_OUT_MILLIS).setMaxRedirects(5).build();
        }
    }
}

