/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.alibaba.nacos.spring.context.annotation.config.ValueAnnotationBeanPostProcessor;
import com.alibaba.nacos.spring.util.ObjectUtils;
import com.alibaba.nacos.spring.util.Tuple;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.InjectionMetadata;

public class NacosValueAnnotationBeanPostProcessor
extends ValueAnnotationBeanPostProcessor<NacosValue> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String BEAN_NAME = "nacosValueAnnotationBeanPostProcessor";

    protected Object doGetInjectedBean(NacosValue annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        String annotationValue = annotation.value();
        String value = this.beanFactory.resolveEmbeddedValue(annotationValue);
        Member member = injectedElement.getMember();
        if (member instanceof Field) {
            return ObjectUtils.convertIfNecessary(this.beanFactory, (Field)member, (Object)value);
        }
        if (member instanceof Method) {
            return ObjectUtils.convertIfNecessary(this.beanFactory, (Method)member, (Object)value);
        }
        return null;
    }

    protected String buildInjectedObjectCacheKey(NacosValue annotation, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return bean.getClass().getName() + annotation;
    }

    @Override
    protected Tuple<String, ValueAnnotationBeanPostProcessor.NacosValueTarget> doWithAnnotation(String beanName, Object bean, NacosValue annotation, int modifiers, Method method, Field field) {
        if (annotation != null) {
            if (Modifier.isStatic(modifiers)) {
                return Tuple.empty();
            }
            if (annotation.autoRefreshed()) {
                String placeholder = this.resolvePlaceholder(annotation.value());
                if (placeholder == null) {
                    return Tuple.empty();
                }
                ValueAnnotationBeanPostProcessor.NacosValueTarget nacosValueTarget = new ValueAnnotationBeanPostProcessor.NacosValueTarget(bean, beanName, method, field);
                nacosValueTarget.setAnnotationType(this.getAnnotationType().getSimpleName());
                this.logger.debug("@NacosValue register auto refresh");
                return Tuple.of(placeholder, nacosValueTarget);
            }
        }
        return Tuple.empty();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.doWithFields(bean, beanName, NacosValue.class);
        this.doWithMethods(bean, beanName, NacosValue.class);
        return super.postProcessBeforeInitialization(bean, beanName);
    }
}

