/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.spring.context.annotation.config.NacosRefresh;
import com.alibaba.nacos.spring.context.annotation.config.ValueAnnotationBeanPostProcessor;
import com.alibaba.nacos.spring.util.ObjectUtils;
import com.alibaba.nacos.spring.util.Tuple;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.annotation.Value;

public class SpringValueAnnotationBeanPostProcessor
extends ValueAnnotationBeanPostProcessor<Value> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String BEAN_NAME = "springValueAnnotationBeanPostProcessor";

    protected Object doGetInjectedBean(Value value, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) throws Exception {
        String annotationValue = value.value();
        String placeHolder = this.beanFactory.resolveEmbeddedValue(annotationValue);
        Member member = injectedElement.getMember();
        if (member instanceof Field) {
            return ObjectUtils.convertIfNecessary(this.beanFactory, (Field)member, (Object)placeHolder);
        }
        if (member instanceof Method) {
            return ObjectUtils.convertIfNecessary(this.beanFactory, (Method)member, (Object)placeHolder);
        }
        return null;
    }

    protected String buildInjectedObjectCacheKey(Value value, Object bean, String beanName, Class<?> injectedType, InjectionMetadata.InjectedElement injectedElement) {
        return bean.getClass().getName() + value;
    }

    @Override
    protected Tuple<String, ValueAnnotationBeanPostProcessor.NacosValueTarget> doWithAnnotation(String beanName, Object bean, Value annotation, int modifiers, Method method, Field field) {
        if (annotation != null) {
            if (Modifier.isStatic(modifiers)) {
                return Tuple.empty();
            }
            if (bean.getClass().isAnnotationPresent(NacosRefresh.class)) {
                String placeholder = this.resolvePlaceholder(annotation.value());
                if (placeholder == null) {
                    return Tuple.empty();
                }
                ValueAnnotationBeanPostProcessor.NacosValueTarget nacosValueTarget = new ValueAnnotationBeanPostProcessor.NacosValueTarget(bean, beanName, method, field);
                nacosValueTarget.setAnnotationType(this.getAnnotationType().getSimpleName());
                this.logger.debug("@Value register auto refresh");
                return Tuple.of(placeholder, nacosValueTarget);
            }
        }
        return Tuple.empty();
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        this.doWithFields(bean, beanName, Value.class);
        this.doWithMethods(bean, beanName, Value.class);
        return super.postProcessBeforeInitialization(bean, beanName);
    }
}

