/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.spring.context.annotation.config;

import com.alibaba.nacos.client.config.utils.MD5;
import com.alibaba.nacos.spring.context.event.config.NacosConfigReceivedEvent;
import com.alibaba.nacos.spring.util.ObjectUtils;
import com.alibaba.nacos.spring.util.Tuple;
import com.alibaba.spring.beans.factory.annotation.AnnotationInjectedBeanPostProcessor;
import com.google.common.base.Objects;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.util.ReflectionUtils;

public abstract class ValueAnnotationBeanPostProcessor<A extends Annotation>
extends AnnotationInjectedBeanPostProcessor<A>
implements BeanFactoryAware,
EnvironmentAware,
ApplicationListener<NacosConfigReceivedEvent> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private static final String PLACEHOLDER_PREFIX = "${";
    private static final String PLACEHOLDER_SUFFIX = "}";
    private static final String VALUE_SEPARATOR = ":";
    protected Map<String, List<NacosValueTarget>> placeholderNacosValueTargetMap = new HashMap<String, List<NacosValueTarget>>();
    protected ConfigurableListableBeanFactory beanFactory;
    protected Environment environment;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (!(beanFactory instanceof ConfigurableListableBeanFactory)) {
            throw new IllegalArgumentException("ValueAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory");
        }
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private void put2ListMap(String key, NacosValueTarget value) {
        if (key == null || value == null) {
            return;
        }
        List<NacosValueTarget> valueList = this.placeholderNacosValueTargetMap.get(key);
        if (valueList == null) {
            valueList = new ArrayList<NacosValueTarget>();
        }
        valueList.add(value);
        this.placeholderNacosValueTargetMap.put(key, valueList);
    }

    protected void setMethod(NacosValueTarget nacosValueTarget, String propertyValue) {
        block3: {
            Method method = nacosValueTarget.method;
            ReflectionUtils.makeAccessible((Method)method);
            try {
                method.invoke(nacosValueTarget.bean, ObjectUtils.convertIfNecessary(this.beanFactory, method, (Object)propertyValue));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Update value with {} (method) in {} (bean) with {}", new Object[]{method.getName(), nacosValueTarget.beanName, propertyValue});
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error("Can't update value with " + method.getName() + " (method) in " + nacosValueTarget.beanName + " (bean)", e);
            }
        }
    }

    protected void setField(NacosValueTarget nacosValueTarget, String propertyValue) {
        block3: {
            Object bean = nacosValueTarget.bean;
            Field field = nacosValueTarget.field;
            String fieldName = field.getName();
            try {
                ReflectionUtils.makeAccessible((Field)field);
                field.set(bean, ObjectUtils.convertIfNecessary(this.beanFactory, field, (Object)propertyValue));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Update value of the {} (field) in {} (bean) with {}", new Object[]{fieldName, nacosValueTarget.beanName, propertyValue});
                }
            }
            catch (Throwable e) {
                if (!this.logger.isErrorEnabled()) break block3;
                this.logger.error("Can't update value of the " + fieldName + " (field) in " + nacosValueTarget.beanName + " (bean)", e);
            }
        }
    }

    protected void doWithFields(final Object bean, final String beanName, final Class<A> aClass) {
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) throws IllegalArgumentException {
                Annotation annotation = AnnotationUtils.getAnnotation((AnnotatedElement)field, (Class)aClass);
                Tuple<String, NacosValueTarget> tuple = ValueAnnotationBeanPostProcessor.this.doWithAnnotation(beanName, bean, annotation, field.getModifiers(), null, field);
                ValueAnnotationBeanPostProcessor.this.put2ListMap(tuple.getFirst(), tuple.getSecond());
            }
        });
    }

    protected void doWithMethods(final Object bean, final String beanName, final Class<A> aClass) {
        ReflectionUtils.doWithMethods(bean.getClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Annotation annotation = AnnotationUtils.getAnnotation((Method)method, (Class)aClass);
                Tuple<String, NacosValueTarget> tuple = ValueAnnotationBeanPostProcessor.this.doWithAnnotation(beanName, bean, annotation, method.getModifiers(), method, null);
                ValueAnnotationBeanPostProcessor.this.put2ListMap(tuple.getFirst(), tuple.getSecond());
            }
        });
    }

    protected abstract Tuple<String, NacosValueTarget> doWithAnnotation(String var1, Object var2, A var3, int var4, Method var5, Field var6);

    protected String resolvePlaceholder(String placeholder) {
        int endIndex;
        if (!placeholder.startsWith(PLACEHOLDER_PREFIX)) {
            return null;
        }
        if (!placeholder.endsWith(PLACEHOLDER_SUFFIX)) {
            return null;
        }
        if (placeholder.length() <= PLACEHOLDER_PREFIX.length() + PLACEHOLDER_SUFFIX.length()) {
            return null;
        }
        int beginIndex = PLACEHOLDER_PREFIX.length();
        int separatorIndex = (placeholder = placeholder.substring(beginIndex, endIndex = placeholder.length() - PLACEHOLDER_PREFIX.length() + 1)).indexOf(VALUE_SEPARATOR);
        if (separatorIndex != -1) {
            return placeholder.substring(0, separatorIndex);
        }
        return placeholder;
    }

    public void onApplicationEvent(NacosConfigReceivedEvent event) {
        for (Map.Entry<String, List<NacosValueTarget>> entry : this.placeholderNacosValueTargetMap.entrySet()) {
            String key = this.environment.resolvePlaceholders(entry.getKey());
            String newValue = this.environment.getProperty(key);
            if (newValue == null) continue;
            List<NacosValueTarget> beanPropertyList = entry.getValue();
            for (NacosValueTarget target : beanPropertyList) {
                String md5String = MD5.getInstance().getMD5String(newValue);
                if (!ValueAnnotationBeanPostProcessor.isChange(md5String, target)) continue;
                target.updateLastMD5(md5String);
                if (target.getMethod() == null) {
                    this.setField(target, newValue);
                    continue;
                }
                this.setMethod(target, newValue);
            }
        }
    }

    protected static boolean isChange(String newMd5, NacosValueTarget target) {
        return !Objects.equal((Object)newMd5, (Object)target.lastMD5);
    }

    public static class NacosValueTarget {
        private final Object bean;
        private final String beanName;
        private final Method method;
        private final Field field;
        private String lastMD5;
        private String annotationType;

        public Object getBean() {
            return this.bean;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Method getMethod() {
            return this.method;
        }

        public Field getField() {
            return this.field;
        }

        public String getLastMD5() {
            return this.lastMD5;
        }

        public void setLastMD5(String lastMD5) {
            this.lastMD5 = lastMD5;
        }

        public String getAnnotationType() {
            return this.annotationType;
        }

        public void setAnnotationType(String annotationType) {
            this.annotationType = annotationType;
        }

        NacosValueTarget(Object bean, String beanName, Method method, Field field) {
            this.bean = bean;
            this.beanName = beanName;
            this.method = method;
            this.field = field;
            this.lastMD5 = "";
        }

        protected void updateLastMD5(String newMD5) {
            this.lastMD5 = newMD5;
        }
    }
}

