/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler;

import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.InsnList;
import agent.org.objectweb.asm.tree.MethodInsnNode;
import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.handler.BaseClassWithContextHandler;
import com.alibaba.testable.agent.handler.test.Framework;
import com.alibaba.testable.agent.handler.test.JUnit4Framework;
import com.alibaba.testable.agent.handler.test.JUnit5Framework;
import com.alibaba.testable.agent.handler.test.SpockFramework;
import com.alibaba.testable.agent.handler.test.TestNgFramework;
import com.alibaba.testable.agent.handler.test.TestNgOnClassFramework;
import com.alibaba.testable.agent.model.TestCaseMethodType;
import com.alibaba.testable.core.util.LogUtil;
import java.util.HashSet;
import java.util.Iterator;

public class TestClassHandler
extends BaseClassWithContextHandler {
    private static final String METHOD_INIT = "init";
    private static final String DESC_METHOD_INIT = "()V";
    private static final String METHOD_CLEAN = "clean";
    private static final String DESC_METHOD_CLEAN = "()V";
    private int testCaseCount = 0;
    private boolean shouldGenerateCleanupMethod = true;
    private final Framework[] frameworkClasses = new Framework[]{new JUnit4Framework(), new JUnit5Framework(), new TestNgFramework(), new TestNgOnClassFramework(), new SpockFramework()};

    @Override
    protected void transform(ClassNode cn) {
        Framework framework = this.checkFramework(cn);
        if (framework == null) {
            LogUtil.warn((String)"Failed to detect test framework for %s", (Object[])new Object[]{cn.name});
            return;
        }
        for (MethodNode mn : cn.methods) {
            this.handleTestableUtil(mn);
            this.handleTestCaseMethod(mn, framework);
        }
        if (this.shouldGenerateCleanupMethod) {
            MethodNode cleanupMethod = framework.getCleanupMethod(cn.name);
            this.injectMockContextClean(cleanupMethod);
            cn.methods.add(cleanupMethod);
        }
        LogUtil.diagnose((String)"  Found %d test cases", (Object[])new Object[]{this.testCaseCount});
    }

    private Framework checkFramework(ClassNode cn) {
        HashSet<String> classAnnotationSet = new HashSet<String>();
        HashSet<String> methodAnnotationSet = new HashSet<String>();
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode an : cn.visibleAnnotations) {
                classAnnotationSet.add(an.desc);
            }
        }
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            for (AnnotationNode annotationNode : mn.visibleAnnotations) {
                methodAnnotationSet.add(annotationNode.desc);
            }
        }
        for (Iterator<Object> iterator : this.frameworkClasses) {
            if (!iterator.fit(classAnnotationSet, methodAnnotationSet)) continue;
            return iterator;
        }
        return null;
    }

    private void handleTestCaseMethod(MethodNode mn, Framework framework) {
        TestCaseMethodType type = framework.checkMethodType(mn);
        if (type.equals((Object)TestCaseMethodType.TEST)) {
            LogUtil.verbose((String)"   Test case \"%s\"", (Object[])new Object[]{mn.name});
            this.injectMockContextInit(mn);
            ++this.testCaseCount;
        } else if (type.equals((Object)TestCaseMethodType.AFTER_TEST)) {
            this.injectMockContextClean(mn);
            this.shouldGenerateCleanupMethod = false;
        }
    }

    private void injectMockContextInit(MethodNode mn) {
        InsnList il = new InsnList();
        il.add(new MethodInsnNode(184, "com/alibaba/testable/core/util/MockContextUtil", METHOD_INIT, "()V", false));
        mn.instructions.insertBefore(mn.instructions.getFirst(), il);
    }

    private void injectMockContextClean(MethodNode mn) {
        mn.instructions.insertBefore(mn.instructions.getFirst(), new MethodInsnNode(184, "com/alibaba/testable/core/util/MockContextUtil", METHOD_CLEAN, "()V", false));
    }
}

