/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler.test;

import agent.org.objectweb.asm.Label;
import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.InsnList;
import agent.org.objectweb.asm.tree.InsnNode;
import agent.org.objectweb.asm.tree.LabelNode;
import agent.org.objectweb.asm.tree.LocalVariableNode;
import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.handler.test.Framework;
import com.alibaba.testable.agent.model.TestCaseMethodType;
import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.agent.util.CollectionUtil;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class CommonFramework
implements Framework {
    private static final String DEFAULT_CLEANUP_METHOD = "testableCleanup";

    @Override
    public boolean fit(Set<String> classAnnotations, Set<String> methodAnnotations) {
        return CollectionUtil.containsAny(methodAnnotations, this.getTestMethodAnnotations());
    }

    @Override
    public TestCaseMethodType checkMethodType(MethodNode mn) {
        if (mn.visibleAnnotations == null) {
            return TestCaseMethodType.OTHERS;
        }
        for (AnnotationNode an : mn.visibleAnnotations) {
            if (this.getTestMethodAnnotations().contains(an.desc)) {
                return TestCaseMethodType.TEST;
            }
            if (!an.desc.equals(this.getCleanupMethodAnnotation())) continue;
            return TestCaseMethodType.AFTER_TEST;
        }
        return TestCaseMethodType.OTHERS;
    }

    @Override
    public MethodNode getCleanupMethod(String className) {
        MethodNode cleanupMethod = new MethodNode(1, DEFAULT_CLEANUP_METHOD, "()V", null, null);
        cleanupMethod.visibleAnnotations = Collections.singletonList(new AnnotationNode(this.getCleanupMethodAnnotation()));
        InsnList il = new InsnList();
        LabelNode startLabel = new LabelNode(new Label());
        LabelNode endLabel = new LabelNode(new Label());
        il.add(startLabel);
        il.add(new InsnNode(177));
        il.add(endLabel);
        cleanupMethod.instructions = il;
        cleanupMethod.localVariables = Collections.singletonList(new LocalVariableNode("this", ClassUtil.toByteCodeClassName(className), null, startLabel, endLabel, 0));
        cleanupMethod.maxLocals = 1;
        cleanupMethod.maxStack = 0;
        return cleanupMethod;
    }

    public abstract List<String> getTestMethodAnnotations();

    public abstract String getCleanupMethodAnnotation();
}

