/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.transformer;

import agent.org.objectweb.asm.Type;
import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.model.MethodInfo;
import com.alibaba.testable.agent.tool.ImmutablePair;
import com.alibaba.testable.agent.util.AnnotationUtil;
import com.alibaba.testable.agent.util.ClassUtil;
import com.alibaba.testable.agent.util.DiagnoseUtil;
import com.alibaba.testable.agent.util.MethodUtil;
import com.alibaba.testable.core.util.LogUtil;
import java.util.ArrayList;
import java.util.List;

public class MockClassParser {
    private static final String CLASS_OBJECT = "java/lang/Object";

    public List<MethodInfo> getTestableMockMethods(String className) {
        ArrayList<MethodInfo> methodInfos = new ArrayList<MethodInfo>();
        ClassNode cn = ClassUtil.getClassNode(className);
        if (cn == null) {
            return new ArrayList<MethodInfo>();
        }
        for (MethodNode mn : this.getAllMethods(cn)) {
            this.checkMethodAnnotation(cn, methodInfos, mn);
        }
        LogUtil.diagnose((String)"  Found %d mock methods", (Object[])new Object[]{methodInfos.size()});
        return methodInfos;
    }

    public boolean isMockClass(ClassNode cn) {
        if (cn == null) {
            return false;
        }
        DiagnoseUtil.setupByClass(cn);
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            for (AnnotationNode an : mn.visibleAnnotations) {
                String fullClassName = ClassUtil.toJavaStyleClassName(an.desc);
                if (!fullClassName.equals("com.alibaba.testable.core.annotation.MockMethod") && !fullClassName.equals("com.alibaba.testable.core.annotation.MockConstructor")) continue;
                return true;
            }
        }
        return false;
    }

    private List<MethodNode> getAllMethods(ClassNode cn) {
        ClassNode scn;
        ArrayList<MethodNode> mns = new ArrayList<MethodNode>(cn.methods);
        if (cn.superName != null && !cn.superName.equals(CLASS_OBJECT) && (scn = ClassUtil.getClassNode(cn.superName)) != null) {
            mns.addAll(this.getAllMethods(scn));
        }
        return mns;
    }

    private void checkMethodAnnotation(ClassNode cn, List<MethodInfo> methodInfos, MethodNode mn) {
        if (mn.visibleAnnotations == null) {
            return;
        }
        for (AnnotationNode an : mn.visibleAnnotations) {
            String targetMethod;
            String fullClassName = ClassUtil.toJavaStyleClassName(an.desc);
            if (fullClassName.equals("com.alibaba.testable.core.annotation.MockConstructor")) {
                if (LogUtil.isVerboseEnabled()) {
                    LogUtil.verbose((String)"   Mock constructor \"%s\" as \"%s\"", (Object[])new Object[]{mn.name, MethodUtil.toJavaMethodDesc(ClassUtil.toJavaStyleClassName(MethodUtil.getReturnType(mn.desc)), mn.desc)});
                }
                this.addMockConstructor(methodInfos, cn, mn);
                continue;
            }
            if (!fullClassName.equals("com.alibaba.testable.core.annotation.MockMethod") || !AnnotationUtil.isValidMockMethod(mn, an)) continue;
            if (LogUtil.isVerboseEnabled()) {
                LogUtil.verbose((String)"   Mock method \"%s\" as \"%s\"", (Object[])new Object[]{mn.name, MethodUtil.toJavaMethodDesc(this.getTargetMethodOwner(mn, an), this.getTargetMethodName(mn, an), this.getTargetMethodDesc(mn, an))});
            }
            if ("<init>".equals(targetMethod = AnnotationUtil.getAnnotationParameter(an, "targetMethod", mn.name, String.class))) {
                this.addMockConstructor(methodInfos, cn, mn);
                break;
            }
            MethodInfo mi = this.getMethodInfo(cn, mn, an, targetMethod);
            if (mi == null) break;
            methodInfos.add(mi);
            break;
        }
    }

    private String getTargetMethodOwner(MethodNode mn, AnnotationNode mockMethodAnnotation) {
        Type type = AnnotationUtil.getAnnotationParameter(mockMethodAnnotation, "targetClass", null, Type.class);
        return type == null ? MethodUtil.getFirstParameter(mn.desc) : type.getClassName();
    }

    private String getTargetMethodName(MethodNode mn, AnnotationNode mockMethodAnnotation) {
        String name = AnnotationUtil.getAnnotationParameter(mockMethodAnnotation, "targetMethod", null, String.class);
        return name == null ? mn.name : name;
    }

    private String getTargetMethodDesc(MethodNode mn, AnnotationNode mockMethodAnnotation) {
        Type type = AnnotationUtil.getAnnotationParameter(mockMethodAnnotation, "targetClass", null, Type.class);
        return type == null ? MethodUtil.removeFirstParameter(mn.desc) : mn.desc;
    }

    private MethodInfo getMethodInfo(ClassNode cn, MethodNode mn, AnnotationNode an, String targetMethod) {
        Type targetType = AnnotationUtil.getAnnotationParameter(an, "targetClass", null, Type.class);
        boolean isStatic = MethodUtil.isStatic(mn);
        if (targetType == null) {
            ImmutablePair<String, String> methodDescPair = this.extractFirstParameter(mn.desc);
            if (methodDescPair == null) {
                return null;
            }
            return new MethodInfo((String)methodDescPair.left, targetMethod, (String)methodDescPair.right, cn.name, mn.name, mn.desc, isStatic);
        }
        String slashSeparatedName = ClassUtil.toSlashSeparatedName(targetType.getClassName());
        return new MethodInfo(slashSeparatedName, targetMethod, mn.desc, cn.name, mn.name, MethodUtil.addParameterAtBegin(mn.desc, ClassUtil.toByteCodeClassName(slashSeparatedName)), isStatic);
    }

    private void addMockConstructor(List<MethodInfo> methodInfos, ClassNode cn, MethodNode mn) {
        String sourceClassName = ClassUtil.getSourceClassName(cn.name);
        methodInfos.add(new MethodInfo(sourceClassName, "<init>", mn.desc, cn.name, mn.name, mn.desc, MethodUtil.isStatic(mn)));
    }

    private ImmutablePair<String, String> extractFirstParameter(String desc) {
        int pos = desc.indexOf(";");
        return pos < 0 ? null : ImmutablePair.of(desc.substring(2, pos), "(" + desc.substring(pos + 1));
    }
}

