/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.util;

import agent.org.objectweb.asm.ClassReader;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.MethodInsnNode;
import com.alibaba.testable.agent.tool.ImmutablePair;
import java.util.HashMap;
import java.util.Map;

public class ClassUtil {
    public static final String CLASS_OBJECT = "java/lang/Object";
    private static final String CLASS_BYTE = "java/lang/Byte";
    private static final String CLASS_CHARACTER = "java/lang/Character";
    private static final String CLASS_DOUBLE = "java/lang/Double";
    private static final String CLASS_FLOAT = "java/lang/Float";
    private static final String CLASS_INTEGER = "java/lang/Integer";
    private static final String CLASS_LONG = "java/lang/Long";
    private static final String CLASS_SHORT = "java/lang/Short";
    private static final String CLASS_BOOLEAN = "java/lang/Boolean";
    private static final String EMPTY = "";
    private static final String METHOD_VALUE_OF = "valueOf";
    private static final String METHOD_BYTE_VALUE = "byteValue";
    private static final String METHOD_CHAR_VALUE = "charValue";
    private static final String METHOD_DOUBLE_VALUE = "doubleValue";
    private static final String METHOD_FLOAT_VALUE = "floatValue";
    private static final String METHOD_INT_VALUE = "intValue";
    private static final String METHOD_LONG_VALUE = "longValue";
    private static final String METHOD_SHORT_VALUE = "shortValue";
    private static final String METHOD_BOOLEAN_VALUE = "booleanValue";
    private static final Map<Byte, String> TYPE_MAPPING = new HashMap<Byte, String>();
    private static final Map<Byte, ImmutablePair<String, String>> WRAPPER_METHOD_MAPPING = new HashMap<Byte, ImmutablePair<String, String>>();
    private static final Map<String, Integer> RETURN_OP_CODE_MAPPING = new HashMap<String, Integer>();

    public static boolean isCompanionClassName(String name) {
        return name.endsWith("$Companion");
    }

    public static String fitCompanionClassName(String name) {
        return ClassUtil.isCompanionClassName(name) ? name.substring(0, name.length() - "$Companion".length()) : name;
    }

    public static String fitKotlinAccessorName(String name) {
        return name.startsWith("access$") ? name.substring("access$".length()) : name;
    }

    public static String getMockClassName(String sourceClassName) {
        return sourceClassName + "Mock";
    }

    public static String getTestClassName(String sourceClassName) {
        return sourceClassName + "Test";
    }

    public static String getSourceClassName(String testClassName) {
        return testClassName.substring(0, testClassName.length() - "Test".length());
    }

    public static String toWrapperClass(Byte primaryType) {
        return TYPE_MAPPING.get(primaryType);
    }

    public static ImmutablePair<String, String> getWrapperTypeConvertMethod(byte primaryType) {
        return WRAPPER_METHOD_MAPPING.get(primaryType);
    }

    public static int getReturnOpsCode(String type) {
        Integer code = RETURN_OP_CODE_MAPPING.get(type);
        return code == null ? 176 : code;
    }

    public static MethodInsnNode getPrimaryTypeConvertMethod(Byte type) {
        String objectType = TYPE_MAPPING.get(type);
        return objectType == null ? null : new MethodInsnNode(184, objectType, METHOD_VALUE_OF, ClassUtil.toDescriptor(type, objectType), false);
    }

    public static String toDotSeparatedName(String name) {
        return name.replace("/", ".");
    }

    public static String toSlashSeparatedName(String name) {
        return name.replace(".", "/");
    }

    public static String toByteCodeClassName(String className) {
        return 'L' + ClassUtil.toSlashSeparatedName(className) + ';';
    }

    public static String toSlashSeparateJavaStyleName(String className) {
        return className.substring(1, className.length() - 1);
    }

    public static String toJavaStyleClassName(String className) {
        return ClassUtil.toDotSeparatedName(ClassUtil.toSlashSeparateJavaStyleName(className));
    }

    public static ClassNode getClassNode(String className) {
        ClassNode cn = new ClassNode();
        try {
            new ClassReader(className).accept(cn, 0);
        }
        catch (Throwable e) {
            return null;
        }
        return cn;
    }

    public static String toOuterClassName(String name) {
        int pos = name.lastIndexOf("$");
        return pos > 0 ? name.substring(0, pos) : name;
    }

    private static String toDescriptor(Byte type, String objectType) {
        return "(" + (char)type.byteValue() + ")L" + objectType + ";";
    }

    static {
        TYPE_MAPPING.put((byte)66, CLASS_BYTE);
        TYPE_MAPPING.put((byte)67, CLASS_CHARACTER);
        TYPE_MAPPING.put((byte)68, CLASS_DOUBLE);
        TYPE_MAPPING.put((byte)70, CLASS_FLOAT);
        TYPE_MAPPING.put((byte)73, CLASS_INTEGER);
        TYPE_MAPPING.put((byte)74, CLASS_LONG);
        TYPE_MAPPING.put((byte)83, CLASS_SHORT);
        TYPE_MAPPING.put((byte)90, CLASS_BOOLEAN);
        TYPE_MAPPING.put((byte)86, EMPTY);
        WRAPPER_METHOD_MAPPING.put((byte)66, ImmutablePair.of(METHOD_BYTE_VALUE, "()B"));
        WRAPPER_METHOD_MAPPING.put((byte)67, ImmutablePair.of(METHOD_CHAR_VALUE, "()C"));
        WRAPPER_METHOD_MAPPING.put((byte)68, ImmutablePair.of(METHOD_DOUBLE_VALUE, "()D"));
        WRAPPER_METHOD_MAPPING.put((byte)70, ImmutablePair.of(METHOD_FLOAT_VALUE, "()F"));
        WRAPPER_METHOD_MAPPING.put((byte)73, ImmutablePair.of(METHOD_INT_VALUE, "()I"));
        WRAPPER_METHOD_MAPPING.put((byte)74, ImmutablePair.of(METHOD_LONG_VALUE, "()J"));
        WRAPPER_METHOD_MAPPING.put((byte)83, ImmutablePair.of(METHOD_SHORT_VALUE, "()S"));
        WRAPPER_METHOD_MAPPING.put((byte)90, ImmutablePair.of(METHOD_BOOLEAN_VALUE, "()Z"));
        RETURN_OP_CODE_MAPPING.put(new String(new byte[]{66}), 172);
        RETURN_OP_CODE_MAPPING.put(new String(new byte[]{67}), 172);
        RETURN_OP_CODE_MAPPING.put(new String(new byte[]{68}), 175);
        RETURN_OP_CODE_MAPPING.put(new String(new byte[]{70}), 174);
        RETURN_OP_CODE_MAPPING.put(new String(new byte[]{73}), 172);
        RETURN_OP_CODE_MAPPING.put(new String(new byte[]{74}), 173);
        RETURN_OP_CODE_MAPPING.put(new String(new byte[]{83}), 172);
        RETURN_OP_CODE_MAPPING.put(new String(new byte[]{90}), 172);
    }
}

