/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.util;

import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.util.ClassUtil;
import java.util.ArrayList;
import java.util.List;

public class MethodUtil {
    private static final String COMMA_SPACE = ", ";

    public static boolean isStatic(MethodNode mn) {
        return (mn.access & 8) != 0;
    }

    public static List<Byte> getParameterTypes(String desc) {
        ArrayList<Byte> parameterTypes = new ArrayList<Byte>();
        boolean travelingClass = false;
        boolean travelingArray = false;
        for (byte b : desc.getBytes()) {
            if (travelingClass) {
                if (b != 59) continue;
                travelingClass = false;
                travelingArray = false;
                continue;
            }
            if (MethodUtil.isPrimaryType(b)) {
                parameterTypes.add(travelingArray ? (byte)76 : b);
                travelingArray = false;
                continue;
            }
            if (b == 76) {
                travelingClass = true;
                parameterTypes.add(b);
                continue;
            }
            if (b == 91) {
                travelingArray = true;
                continue;
            }
            if (b == 41) break;
        }
        return parameterTypes;
    }

    public static String extractParameters(String desc) {
        int returnTypeEdge = desc.lastIndexOf(41);
        return desc.substring(1, returnTypeEdge);
    }

    public static String getReturnType(String desc) {
        int returnTypeEdge = desc.lastIndexOf(41);
        return desc.substring(returnTypeEdge + 1);
    }

    public static String getFirstParameter(String desc) {
        int typeEdge = desc.indexOf(59);
        return typeEdge > 0 ? desc.substring(1, typeEdge + 1) : "";
    }

    public static String removeFirstParameter(String desc) {
        return "(" + desc.substring(desc.indexOf(";") + 1);
    }

    public static String addParameterAtBegin(String desc, String type) {
        return "(" + type + desc.substring(1);
    }

    private static boolean isPrimaryType(byte b) {
        return b == 66 || b == 67 || b == 68 || b == 70 || b == 73 || b == 74 || b == 83 || b == 90;
    }

    public static String toJavaMethodDesc(String owner, String desc) {
        String ownerInDotFormat = ClassUtil.toDotSeparatedName(owner);
        String parameters = MethodUtil.toJavaParameterDesc(MethodUtil.extractParameters(desc));
        return String.format("%s(%s)", ownerInDotFormat, parameters);
    }

    public static String toJavaMethodDesc(String owner, String name, String desc) {
        String ownerInDotFormat = ClassUtil.toDotSeparatedName(owner);
        String returnType = MethodUtil.toJavaParameterDesc(MethodUtil.getReturnType(desc));
        String parameters = MethodUtil.toJavaParameterDesc(MethodUtil.extractParameters(desc));
        return String.format("%s::%s(%s) : %s", ownerInDotFormat, name, parameters, returnType);
    }

    private static String toJavaParameterDesc(String desc) {
        if (desc.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isArray = false;
        boolean isTravellingClass = false;
        block17: for (byte b : desc.getBytes()) {
            if (isTravellingClass) {
                switch (b) {
                    case 59: {
                        sb.append(isArray ? "[]" : "");
                        isArray = false;
                        isTravellingClass = false;
                        break;
                    }
                    case 47: {
                        sb.append('.');
                        break;
                    }
                    default: {
                        sb.append((char)b);
                        break;
                    }
                }
                continue;
            }
            switch (b) {
                case 91: {
                    isArray = true;
                    continue block17;
                }
                case 86: {
                    sb.append(COMMA_SPACE).append("void");
                    continue block17;
                }
                case 66: {
                    sb.append(COMMA_SPACE).append("byte").append(isArray ? "[]" : "");
                    isArray = false;
                    continue block17;
                }
                case 67: {
                    sb.append(COMMA_SPACE).append("char").append(isArray ? "[]" : "");
                    isArray = false;
                    continue block17;
                }
                case 68: {
                    sb.append(COMMA_SPACE).append("double").append(isArray ? "[]" : "");
                    isArray = false;
                    continue block17;
                }
                case 70: {
                    sb.append(COMMA_SPACE).append("float").append(isArray ? "[]" : "");
                    isArray = false;
                    continue block17;
                }
                case 73: {
                    sb.append(COMMA_SPACE).append("int").append(isArray ? "[]" : "");
                    isArray = false;
                    continue block17;
                }
                case 74: {
                    sb.append(COMMA_SPACE).append("long").append(isArray ? "[]" : "");
                    isArray = false;
                    continue block17;
                }
                case 83: {
                    sb.append(COMMA_SPACE).append("short").append(isArray ? "[]" : "");
                    isArray = false;
                    continue block17;
                }
                case 90: {
                    sb.append(COMMA_SPACE).append("boolean").append(isArray ? "[]" : "");
                    isArray = false;
                    continue block17;
                }
                case 76: {
                    sb.append(COMMA_SPACE);
                    isTravellingClass = true;
                    continue block17;
                }
            }
        }
        return sb.substring(COMMA_SPACE.length());
    }
}

