/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler;

import agent.org.objectweb.asm.tree.AbstractInsnNode;
import agent.org.objectweb.asm.tree.FieldInsnNode;
import agent.org.objectweb.asm.tree.InsnList;
import agent.org.objectweb.asm.tree.MethodInsnNode;
import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.handler.BaseClassHandler;

public abstract class BaseClassWithContextHandler
extends BaseClassHandler {
    protected static final String CLASS_MOCK_CONTEXT_UTIL = "com/alibaba/testable/core/util/MockContextUtil";
    private static final String CLASS_TESTABLE_TOOL = "com/alibaba/testable/core/tool/TestableTool";
    private static final String CLASS_TESTABLE_UTIL = "com/alibaba/testable/core/util/TestableUtil";
    private static final String FIELD_SOURCE_METHOD = "SOURCE_METHOD";
    private static final String FIELD_MOCK_CONTEXT = "MOCK_CONTEXT";
    private static final String METHOD_PARAMETERS = "parameters";
    private static final String METHOD_CURRENT_SOURCE_METHOD_NAME = "currentSourceMethodName";
    private static final String SIGNATURE_CURRENT_SOURCE_METHOD_NAME = "()Ljava/lang/String;";
    private static final String SIGNATURE_PARAMETERS = "()Ljava/util/Map;";

    protected void handleTestableUtil(MethodNode mn) {
        AbstractInsnNode[] instructions = mn.instructions.toArray();
        for (int i = 0; i < instructions.length; ++i) {
            FieldInsnNode fieldInsnNode;
            if (instructions[i].getOpcode() != 178 || !this.isTestableUtilField(fieldInsnNode = (FieldInsnNode)instructions[i])) continue;
            this.replaceTestableUtilField(mn, instructions, fieldInsnNode.name, i);
            instructions = mn.instructions.toArray();
        }
    }

    private boolean isTestableUtilField(FieldInsnNode fieldInsnNode) {
        return fieldInsnNode.owner.equals(CLASS_TESTABLE_TOOL) && (fieldInsnNode.name.equals(FIELD_SOURCE_METHOD) || fieldInsnNode.name.equals(FIELD_MOCK_CONTEXT));
    }

    private void replaceTestableUtilField(MethodNode mn, AbstractInsnNode[] instructions, String fieldName, int pos) {
        InsnList il = new InsnList();
        if (FIELD_SOURCE_METHOD.equals(fieldName)) {
            il.add(new MethodInsnNode(184, CLASS_TESTABLE_UTIL, METHOD_CURRENT_SOURCE_METHOD_NAME, SIGNATURE_CURRENT_SOURCE_METHOD_NAME, false));
        } else if (FIELD_MOCK_CONTEXT.equals(fieldName)) {
            il.add(new MethodInsnNode(184, CLASS_MOCK_CONTEXT_UTIL, METHOD_PARAMETERS, SIGNATURE_PARAMETERS, false));
        }
        if (il.size() > 0) {
            mn.instructions.insert(instructions[pos], il);
            mn.instructions.remove(instructions[pos]);
        }
    }
}

