/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.handler;

import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.InsnList;
import agent.org.objectweb.asm.tree.MethodInsnNode;
import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.handler.BaseClassWithContextHandler;
import com.alibaba.testable.agent.handler.test.Framework;
import com.alibaba.testable.agent.model.TestCaseMethodType;
import com.alibaba.testable.core.util.LogUtil;

public class TestClassHandler
extends BaseClassWithContextHandler {
    private static final String METHOD_INIT = "init";
    private static final String DESC_METHOD_INIT = "()V";
    private static final String METHOD_CLEAN = "clean";
    private static final String DESC_METHOD_CLEAN = "()V";
    private int testCaseCount = 0;
    private boolean shouldGenerateCleanupMethod = true;
    private final Framework framework;

    public TestClassHandler(Framework framework) {
        this.framework = framework;
    }

    @Override
    protected void transform(ClassNode cn) {
        LogUtil.diagnose((String)"Found test class %s", (Object[])new Object[]{cn.name});
        for (MethodNode mn : cn.methods) {
            this.handleTestableUtil(mn);
            this.handleTestCaseMethod(mn, this.framework);
        }
        if (this.shouldGenerateCleanupMethod) {
            MethodNode cleanupMethod = this.framework.getCleanupMethod(cn.name);
            this.injectMockContextClean(cleanupMethod);
            cn.methods.add(cleanupMethod);
        }
        LogUtil.diagnose((String)"  Found %d test cases", (Object[])new Object[]{this.testCaseCount});
    }

    private void handleTestCaseMethod(MethodNode mn, Framework framework) {
        TestCaseMethodType type = framework.checkMethodType(mn);
        if (type.equals((Object)TestCaseMethodType.TEST)) {
            LogUtil.verbose((String)"   Test case \"%s\"", (Object[])new Object[]{mn.name});
            this.injectMockContextInit(mn);
            ++this.testCaseCount;
        } else if (type.equals((Object)TestCaseMethodType.AFTER_TEST)) {
            this.injectMockContextClean(mn);
            this.shouldGenerateCleanupMethod = false;
        }
    }

    private void injectMockContextInit(MethodNode mn) {
        InsnList il = new InsnList();
        il.add(new MethodInsnNode(184, "com/alibaba/testable/core/util/MockContextUtil", METHOD_INIT, "()V", false));
        mn.instructions.insertBefore(mn.instructions.getFirst(), il);
    }

    private void injectMockContextClean(MethodNode mn) {
        mn.instructions.insertBefore(mn.instructions.getFirst(), new MethodInsnNode(184, "com/alibaba/testable/core/util/MockContextUtil", METHOD_CLEAN, "()V", false));
    }
}

