/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.model;

import com.alibaba.testable.agent.model.WrapperType;

public enum BasicType {
    L_TYPE('L', Object.class, WrapperType.OBJECT, 25, 176),
    I_TYPE('I', Integer.TYPE, WrapperType.INT, 21, 172),
    J_TYPE('J', Long.TYPE, WrapperType.LONG, 22, 173),
    F_TYPE('F', Float.TYPE, WrapperType.FLOAT, 23, 174),
    D_TYPE('D', Double.TYPE, WrapperType.DOUBLE, 24, 175),
    V_TYPE('V', Void.TYPE, WrapperType.VOID, null, 177),
    A_TYPE('[', Object[].class, WrapperType.OBJECT, 25, 176);

    public final char btChar;
    public final Class<?> btClass;
    public final WrapperType btWrapper;
    public final Integer loadVarInsn;
    public final Integer returnInsn;

    private BasicType(char btChar, Class<?> btClass, WrapperType btWrapper, Integer loadVarInsn, Integer returnInsn) {
        this.btChar = btChar;
        this.btClass = btClass;
        this.btWrapper = btWrapper;
        this.loadVarInsn = loadVarInsn;
        this.returnInsn = returnInsn;
    }

    public boolean isPrimitive() {
        return this != L_TYPE && this != A_TYPE;
    }

    public static BasicType basicType(char type) {
        switch (type) {
            case 'L': {
                return L_TYPE;
            }
            case 'I': {
                return I_TYPE;
            }
            case 'J': {
                return J_TYPE;
            }
            case 'F': {
                return F_TYPE;
            }
            case 'D': {
                return D_TYPE;
            }
            case 'V': {
                return V_TYPE;
            }
            case '[': {
                return A_TYPE;
            }
            case 'B': 
            case 'C': 
            case 'S': 
            case 'Z': {
                return I_TYPE;
            }
        }
        throw new InternalError("Unknown type char: '" + type + "'");
    }
}

