/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.model;

import agent.org.objectweb.asm.Handle;
import agent.org.objectweb.asm.Type;
import com.alibaba.testable.core.util.StringUtil;

public class BsmArg {
    private Type handleDesc;
    private Type methodDesc;
    private Handle handle;
    private final Object[] bsmArgs;
    private final String originalHandleDesc;

    public BsmArg(Object[] bsmArgs) {
        this.bsmArgs = bsmArgs;
        this.handle = (Handle)bsmArgs[1];
        this.methodDesc = (Type)bsmArgs[2];
        this.handleDesc = Type.getType(this.handle.getDesc());
        this.originalHandleDesc = this.handle.getDesc();
        if (this.handle.getTag() == 5 || this.handle.getTag() == 9) {
            Type[] argumentTypes = this.handleDesc.getArgumentTypes();
            Type thisArgument = Type.getType("L" + this.handle.getOwner() + ";");
            String handleDescString = this.refineHandle(thisArgument, argumentTypes);
            this.handle = new Handle(this.handle.getTag(), this.handle.getOwner(), this.handle.getName(), handleDescString, this.handle.isInterface());
            this.handleDesc = Type.getType(handleDescString);
            if (this.methodDesc.getArgumentTypes().length == this.handleDesc.getArgumentTypes().length - 1) {
                Type[] methodArguments = this.methodDesc.getArgumentTypes();
                String methodDescString = this.refineHandle(thisArgument, methodArguments);
                this.methodDesc = Type.getType(methodDescString);
            }
        }
    }

    private String refineHandle(Type thisArgument, Type[] argumentTypes) {
        Type[] handleArguments = new Type[argumentTypes.length + 1];
        String[] handleArgs = new String[argumentTypes.length + 1];
        handleArguments[0] = thisArgument;
        System.arraycopy(argumentTypes, 0, handleArguments, 1, argumentTypes.length);
        for (int i = 0; i < handleArguments.length; ++i) {
            handleArgs[i] = handleArguments[i].getDescriptor();
        }
        return "(" + StringUtil.join((String)"", (String[])handleArgs) + ")" + this.handleDesc.getReturnType().getDescriptor();
    }

    public Type getHandleDesc() {
        return this.handleDesc;
    }

    public Type getMethodDesc() {
        return this.methodDesc;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public String getOriginalHandleDesc() {
        return this.originalHandleDesc;
    }

    public boolean isStatic() {
        int tag = this.handle.getTag();
        return tag == 6 || tag == 5 || tag == 9;
    }

    public void complete(String owner, String methodName) {
        this.bsmArgs[1] = new Handle(this.isStatic() ? 6 : 5, owner, methodName, this.handleDesc.getDescriptor(), false);
    }
}

