/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.testable.agent.transformer;

import agent.org.objectweb.asm.tree.AnnotationNode;
import agent.org.objectweb.asm.tree.ClassNode;
import agent.org.objectweb.asm.tree.MethodNode;
import com.alibaba.testable.agent.handler.test.Framework;
import com.alibaba.testable.agent.handler.test.JUnit4Framework;
import com.alibaba.testable.agent.handler.test.JUnit5Framework;
import com.alibaba.testable.agent.handler.test.SpockFramework;
import com.alibaba.testable.agent.handler.test.TestNgFramework;
import com.alibaba.testable.agent.handler.test.TestNgOnClassFramework;
import java.util.HashSet;
import java.util.Iterator;

public class TestClassChecker {
    private final Framework[] frameworkClasses = new Framework[]{new JUnit4Framework(), new JUnit5Framework(), new TestNgFramework(), new TestNgOnClassFramework(), new SpockFramework()};

    public Framework checkFramework(ClassNode cn) {
        HashSet<String> classAnnotationSet = new HashSet<String>();
        HashSet<String> methodAnnotationSet = new HashSet<String>();
        if (cn.visibleAnnotations != null) {
            for (AnnotationNode an : cn.visibleAnnotations) {
                classAnnotationSet.add(an.desc);
            }
        }
        for (MethodNode mn : cn.methods) {
            if (mn.visibleAnnotations == null) continue;
            for (AnnotationNode annotationNode : mn.visibleAnnotations) {
                methodAnnotationSet.add(annotationNode.desc);
            }
        }
        for (Iterator<Object> iterator : this.frameworkClasses) {
            if (!iterator.fit(classAnnotationSet, methodAnnotationSet)) continue;
            return iterator;
        }
        return null;
    }
}

