/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.logback;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import com.aliyun.openservices.log.common.LogItem;
import com.aliyun.openservices.log.logback.LoghubAppenderCallback;
import com.aliyun.openservices.log.producer.LogProducer;
import com.aliyun.openservices.log.producer.ProducerConfig;
import com.aliyun.openservices.log.producer.ProjectConfig;
import java.util.ArrayList;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class LoghubAppender<E>
extends UnsynchronizedAppenderBase<E> {
    protected Encoder<E> encoder;
    protected ProducerConfig producerConfig = new ProducerConfig();
    protected ProjectConfig projectConfig = new ProjectConfig();
    protected LogProducer producer;
    protected String logstore;
    protected String topic = "";
    protected String source = "";
    protected String timeZone = "UTC";
    protected String timeFormat = "yyyy-MM-dd'T'HH:mmZ";
    protected DateTimeFormatter formatter;

    public void start() {
        try {
            this.doStart();
        }
        catch (Exception e) {
            this.addError("Failed to start LoghubAppender.", e);
        }
    }

    private void doStart() {
        this.formatter = DateTimeFormat.forPattern((String)this.timeFormat).withZone(DateTimeZone.forID((String)this.timeZone));
        this.producerConfig.userAgent = "logback";
        this.producer = new LogProducer(this.producerConfig);
        this.producer.setProjectConfig(this.projectConfig);
        super.start();
    }

    public void stop() {
        try {
            this.doStop();
        }
        catch (Exception e) {
            this.addError("Failed to stop LoghubAppender.", e);
        }
    }

    private void doStop() throws InterruptedException {
        if (!this.isStarted()) {
            return;
        }
        super.stop();
        this.producer.flush();
        this.producer.close();
    }

    public void append(E eventObject) {
        try {
            this.appendEvent(eventObject);
        }
        catch (Exception e) {
            this.addError("Failed to append event.", e);
        }
    }

    private void appendEvent(E eventObject) {
        if (!(eventObject instanceof LoggingEvent)) {
            return;
        }
        LoggingEvent event = (LoggingEvent)eventObject;
        ArrayList<LogItem> logItems = new ArrayList<LogItem>();
        LogItem item = new LogItem();
        logItems.add(item);
        item.SetTime((int)(event.getTimeStamp() / 1000L));
        DateTime dateTime = new DateTime(event.getTimeStamp());
        item.PushBack("time", dateTime.toString(this.formatter));
        item.PushBack("level", event.getLevel().toString());
        item.PushBack("thread", event.getThreadName());
        StackTraceElement[] caller = event.getCallerData();
        if (caller != null && caller.length > 0) {
            item.PushBack("location", caller[0].toString());
        }
        String message = event.getFormattedMessage();
        item.PushBack("message", message);
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            String throwable = this.getExceptionInfo(iThrowableProxy);
            throwable = throwable + this.fullDump(event.getThrowableProxy().getStackTraceElementProxyArray());
            item.PushBack("throwable", throwable);
        }
        if (this.encoder != null) {
            item.PushBack("log", new String(this.encoder.encode(eventObject)));
        }
        this.producer.send(this.projectConfig.projectName, this.logstore, this.topic, this.source, logItems, new LoghubAppenderCallback(this, this.projectConfig.projectName, this.logstore, this.topic, this.source, logItems));
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    private String getExceptionInfo(IThrowableProxy iThrowableProxy) {
        String s = iThrowableProxy.getClassName();
        String message = iThrowableProxy.getMessage();
        return message != null ? s + ": " + message : s;
    }

    private String fullDump(StackTraceElementProxy[] stackTraceElementProxyArray) {
        StringBuilder builder = new StringBuilder();
        for (StackTraceElementProxy step : stackTraceElementProxyArray) {
            builder.append(CoreConstants.LINE_SEPARATOR);
            String string = step.toString();
            builder.append('\t').append(string);
            ThrowableProxyUtil.subjoinPackagingData((StringBuilder)builder, (StackTraceElementProxy)step);
        }
        return builder.toString();
    }

    public String getLogstore() {
        return this.logstore;
    }

    public void setLogstore(String logstore) {
        this.logstore = logstore;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getProjectName() {
        return this.projectConfig.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectConfig.projectName = projectName;
    }

    public String getEndpoint() {
        return this.projectConfig.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.projectConfig.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.projectConfig.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.projectConfig.accessKeyId = accessKeyId;
    }

    public String getAccessKey() {
        return this.projectConfig.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.projectConfig.accessKey = accessKey;
    }

    public String getStsToken() {
        return this.projectConfig.stsToken;
    }

    public void setStsToken(String stsToken) {
        this.projectConfig.stsToken = stsToken;
    }

    public int getPackageTimeoutInMS() {
        return this.producerConfig.packageTimeoutInMS;
    }

    public void setPackageTimeoutInMS(int packageTimeoutInMS) {
        this.producerConfig.packageTimeoutInMS = packageTimeoutInMS;
    }

    public int getLogsCountPerPackage() {
        return this.producerConfig.logsCountPerPackage;
    }

    public void setLogsCountPerPackage(int logsCountPerPackage) {
        this.producerConfig.logsCountPerPackage = logsCountPerPackage;
    }

    public int getLogsBytesPerPackage() {
        return this.producerConfig.logsBytesPerPackage;
    }

    public void setLogsBytesPerPackage(int logsBytesPerPackage) {
        this.producerConfig.logsBytesPerPackage = logsBytesPerPackage;
    }

    public int getMemPoolSizeInByte() {
        return this.producerConfig.memPoolSizeInByte;
    }

    public void setMemPoolSizeInByte(int memPoolSizeInByte) {
        this.producerConfig.memPoolSizeInByte = memPoolSizeInByte;
    }

    public int getMaxIOThreadSizeInPool() {
        return this.producerConfig.maxIOThreadSizeInPool;
    }

    public void setMaxIOThreadSizeInPool(int ioThreadsCount) {
        this.producerConfig.maxIOThreadSizeInPool = ioThreadsCount;
    }

    public int getRetryTimes() {
        return this.producerConfig.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.producerConfig.retryTimes = retryTimes;
    }

    public Encoder<E> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<E> encoder) {
        this.encoder = encoder;
    }
}

