/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer.internal;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.util.IOUtils;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@SdkInternalApi
public class DownloadPartCallable
implements Callable<Long> {
    private static final Log LOG = LogFactory.getLog(DownloadPartCallable.class);
    private static final int BUFFER_SIZE = 0x200000;
    private final AmazonS3 s3;
    private final GetObjectRequest getPartRequest;
    private final File destinationFile;
    private final long position;

    public DownloadPartCallable(AmazonS3 s3, GetObjectRequest getPartRequest, File destinationFile, long position) {
        this.s3 = s3;
        this.destinationFile = destinationFile;
        this.getPartRequest = getPartRequest;
        this.position = position;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long call() throws Exception {
        long filePosition;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.destinationFile, "rw");
        FileChannel channel = randomAccessFile.getChannel();
        channel.position(this.position);
        S3ObjectInputStream objectContent = null;
        try {
            int bytesRead;
            S3Object object = this.s3.getObject(this.getPartRequest);
            objectContent = object.getObjectContent();
            byte[] buffer = new byte[0x200000];
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(0x200000);
            while ((bytesRead = objectContent.read(buffer)) > -1) {
                byteBuffer.put(buffer, 0, bytesRead);
                byteBuffer.flip();
                while (byteBuffer.hasRemaining()) {
                    channel.write(byteBuffer);
                }
                byteBuffer.clear();
            }
            filePosition = channel.position();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(objectContent, (Log)LOG);
            IOUtils.closeQuietly((Closeable)randomAccessFile, (Log)LOG);
            IOUtils.closeQuietly((Closeable)channel, (Log)LOG);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)((Object)objectContent), (Log)LOG);
        IOUtils.closeQuietly((Closeable)randomAccessFile, (Log)LOG);
        IOUtils.closeQuietly((Closeable)channel, (Log)LOG);
        return filePosition;
    }
}

