/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.amqp.models;

import com.azure.core.amqp.models.AmqpMessageBodyType;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class AmqpMessageBody {
    private final ClientLogger logger = new ClientLogger(AmqpMessageBody.class);
    private AmqpMessageBodyType bodyType;
    private byte[] data;
    private List<byte[]> dataList;

    private AmqpMessageBody() {
    }

    public static AmqpMessageBody fromData(byte[] data) {
        Objects.requireNonNull(data, "'data' cannot be null.");
        AmqpMessageBody body = new AmqpMessageBody();
        body.bodyType = AmqpMessageBodyType.DATA;
        body.data = data;
        return body;
    }

    public AmqpMessageBodyType getBodyType() {
        return this.bodyType;
    }

    public IterableStream<byte[]> getData() {
        if (this.bodyType != AmqpMessageBodyType.DATA) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("This method can only be called for AMQP Data body type at present. Track this issue, https://github.com/Azure/azure-sdk-for-java/issues/17614 for other body type support in future."));
        }
        if (this.dataList == null) {
            this.dataList = Collections.singletonList(this.data);
        }
        return new IterableStream(this.dataList);
    }

    public byte[] getFirstData() {
        if (this.bodyType != AmqpMessageBodyType.DATA) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("This method can only be called for AMQP Data body type at present. Track this issue, https://github.com/Azure/azure-sdk-for-java/issues/17614 for other body type support in future."));
        }
        return this.data;
    }
}

