/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.messaging.servicebus.administration.models.AuthorizationRule;
import com.azure.messaging.servicebus.administration.models.EntityStatus;
import com.azure.messaging.servicebus.administration.models.SharedAccessAuthorizationRule;
import com.azure.messaging.servicebus.implementation.EntityHelper;
import com.azure.messaging.servicebus.implementation.MessageUtils;
import com.azure.messaging.servicebus.implementation.models.AuthorizationRuleImpl;
import com.azure.messaging.servicebus.implementation.models.EntityAvailabilityStatus;
import com.azure.messaging.servicebus.implementation.models.MessageCountDetails;
import com.azure.messaging.servicebus.implementation.models.QueueDescription;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public final class QueueProperties {
    private Duration autoDeleteOnIdle;
    private final OffsetDateTime accessedAt;
    private List<AuthorizationRule> authorizationRules;
    private final OffsetDateTime createdAt;
    private Duration defaultMessageTimeToLive;
    private boolean deadLetteringOnMessageExpiration;
    private Duration duplicateDetectionHistoryTimeWindow;
    private boolean enableBatchedOperations;
    private final Boolean enableExpress;
    private boolean enablePartitioning;
    private final EntityAvailabilityStatus entityAvailabilityStatus;
    private String forwardTo;
    private String forwardDeadLetteredMessagesTo;
    private final Boolean isAnonymousAccessible;
    private Duration lockDuration;
    private int maxDeliveryCount;
    private long maxSizeInMegabytes;
    private final int messageCount;
    private final MessageCountDetails messageCountDetails;
    private boolean requiresDuplicateDetection;
    private boolean requiresSession;
    private final int sizeInBytes;
    private EntityStatus status;
    private final Boolean supportOrdering;
    private final OffsetDateTime updatedAt;
    private String userMetadata;
    private String queueName;

    QueueProperties(QueueDescription description) {
        this.accessedAt = description.getAccessedAt();
        this.autoDeleteOnIdle = description.getAutoDeleteOnIdle();
        this.authorizationRules = description.getAuthorizationRules().stream().map(SharedAccessAuthorizationRule::new).collect(Collectors.toList());
        this.createdAt = description.getCreatedAt();
        this.defaultMessageTimeToLive = description.getDefaultMessageTimeToLive();
        this.deadLetteringOnMessageExpiration = MessageUtils.toPrimitive(description.isDeadLetteringOnMessageExpiration());
        this.duplicateDetectionHistoryTimeWindow = description.getDuplicateDetectionHistoryTimeWindow();
        this.enableBatchedOperations = MessageUtils.toPrimitive(description.isEnableBatchedOperations());
        this.enableExpress = description.isEnableExpress();
        this.enablePartitioning = MessageUtils.toPrimitive(description.isEnablePartitioning());
        this.entityAvailabilityStatus = description.getEntityAvailabilityStatus();
        this.isAnonymousAccessible = description.isAnonymousAccessible();
        this.forwardTo = description.getForwardTo();
        this.forwardDeadLetteredMessagesTo = description.getForwardDeadLetteredMessagesTo();
        this.lockDuration = description.getLockDuration();
        this.maxDeliveryCount = MessageUtils.toPrimitive(description.getMaxDeliveryCount());
        this.maxSizeInMegabytes = MessageUtils.toPrimitive(description.getMaxSizeInMegabytes());
        this.messageCount = MessageUtils.toPrimitive(description.getMessageCount());
        this.messageCountDetails = description.getMessageCountDetails();
        this.requiresDuplicateDetection = MessageUtils.toPrimitive(description.isRequiresDuplicateDetection());
        this.requiresSession = MessageUtils.toPrimitive(description.isRequiresSession());
        this.sizeInBytes = MessageUtils.toPrimitive(description.getSizeInBytes());
        this.supportOrdering = description.isSupportOrdering();
        this.status = description.getStatus();
        this.updatedAt = description.getUpdatedAt();
        this.userMetadata = description.getUserMetadata();
    }

    public String getName() {
        return this.queueName;
    }

    public Duration getAutoDeleteOnIdle() {
        return this.autoDeleteOnIdle;
    }

    public QueueProperties setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        this.autoDeleteOnIdle = autoDeleteOnIdle;
        return this;
    }

    public List<AuthorizationRule> getAuthorizationRules() {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList<AuthorizationRule>();
        }
        return this.authorizationRules;
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.defaultMessageTimeToLive;
    }

    public QueueProperties setDefaultMessageTimeToLive(Duration defaultMessageTimeToLive) {
        this.defaultMessageTimeToLive = defaultMessageTimeToLive;
        return this;
    }

    public boolean isDeadLetteringOnMessageExpiration() {
        return this.deadLetteringOnMessageExpiration;
    }

    public QueueProperties setDeadLetteringOnMessageExpiration(boolean deadLetteringOnMessageExpiration) {
        this.deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration;
        return this;
    }

    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return this.duplicateDetectionHistoryTimeWindow;
    }

    public QueueProperties setDuplicateDetectionHistoryTimeWindow(Duration duplicateDetectionHistoryTimeWindow) {
        this.duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow;
        return this;
    }

    public boolean isBatchedOperationsEnabled() {
        return this.enableBatchedOperations;
    }

    public QueueProperties setBatchedOperationsEnabled(boolean enableBatchedOperations) {
        this.enableBatchedOperations = enableBatchedOperations;
        return this;
    }

    public boolean isPartitioningEnabled() {
        return this.enablePartitioning;
    }

    public String getForwardTo() {
        return this.forwardTo;
    }

    public QueueProperties setForwardTo(String forwardTo) {
        this.forwardTo = forwardTo;
        return this;
    }

    public String getForwardDeadLetteredMessagesTo() {
        return this.forwardDeadLetteredMessagesTo;
    }

    public QueueProperties setForwardDeadLetteredMessagesTo(String forwardDeadLetteredMessagesTo) {
        this.forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo;
        return this;
    }

    public Duration getLockDuration() {
        return this.lockDuration;
    }

    public QueueProperties setLockDuration(Duration lockDuration) {
        this.lockDuration = lockDuration;
        return this;
    }

    public int getMaxDeliveryCount() {
        return this.maxDeliveryCount;
    }

    public QueueProperties setMaxDeliveryCount(Integer maxDeliveryCount) {
        this.maxDeliveryCount = maxDeliveryCount;
        return this;
    }

    public long getMaxSizeInMegabytes() {
        return this.maxSizeInMegabytes;
    }

    public QueueProperties setMaxSizeInMegabytes(Integer maxSizeInMegabytes) {
        this.maxSizeInMegabytes = maxSizeInMegabytes.intValue();
        return this;
    }

    public boolean isDuplicateDetectionRequired() {
        return this.requiresDuplicateDetection;
    }

    public boolean isSessionRequired() {
        return this.requiresSession;
    }

    public EntityStatus getStatus() {
        return this.status;
    }

    public QueueProperties setStatus(EntityStatus status) {
        this.status = status;
        return this;
    }

    public String getUserMetadata() {
        return this.userMetadata;
    }

    public QueueProperties setUserMetadata(String userMetadata) {
        this.userMetadata = userMetadata;
        return this;
    }

    OffsetDateTime getAccessedAt() {
        return this.accessedAt;
    }

    OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    Integer getMessageCount() {
        return this.messageCount;
    }

    MessageCountDetails getMessageCountDetails() {
        return this.messageCountDetails;
    }

    Integer getSizeInBytes() {
        return this.sizeInBytes;
    }

    OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    QueueProperties setPartitioningEnabled(boolean enablePartitioning) {
        this.enablePartitioning = enablePartitioning;
        return this;
    }

    QueueProperties setDuplicateDetectionRequired(boolean requiresDuplicateDetection) {
        this.requiresDuplicateDetection = requiresDuplicateDetection;
        return this;
    }

    QueueProperties setSessionRequired(boolean requiresSession) {
        this.requiresSession = requiresSession;
        return this;
    }

    static {
        EntityHelper.setQueueAccessor(new EntityHelper.QueueAccessor(){

            @Override
            public QueueDescription toImplementation(QueueProperties queue, List<AuthorizationRuleImpl> rules) {
                QueueDescription description = new QueueDescription().setAccessedAt(queue.getAccessedAt()).setAutoDeleteOnIdle(queue.getAutoDeleteOnIdle()).setCreatedAt(queue.getCreatedAt()).setDeadLetteringOnMessageExpiration(queue.isDeadLetteringOnMessageExpiration()).setDefaultMessageTimeToLive(queue.getDefaultMessageTimeToLive()).setDuplicateDetectionHistoryTimeWindow(queue.getDuplicateDetectionHistoryTimeWindow()).setEnablePartitioning(queue.isPartitioningEnabled()).setEnableExpress(queue.enableExpress).setEnableBatchedOperations(queue.enableBatchedOperations).setEntityAvailabilityStatus(queue.entityAvailabilityStatus).setForwardTo(queue.getForwardTo()).setForwardDeadLetteredMessagesTo(queue.getForwardDeadLetteredMessagesTo()).setIsAnonymousAccessible(queue.isAnonymousAccessible).setLockDuration(queue.getLockDuration()).setMaxSizeInMegabytes(queue.getMaxSizeInMegabytes()).setMaxDeliveryCount(queue.getMaxDeliveryCount()).setMessageCount(queue.messageCount).setMessageCountDetails(queue.getMessageCountDetails()).setSupportOrdering(queue.supportOrdering).setStatus(queue.getStatus()).setSizeInBytes(queue.getSizeInBytes()).setRequiresSession(queue.isSessionRequired()).setRequiresDuplicateDetection(queue.isDuplicateDetectionRequired()).setUpdatedAt(queue.getUpdatedAt()).setUserMetadata(queue.getUserMetadata());
                if (!rules.isEmpty()) {
                    description.setAuthorizationRules(rules);
                }
                return description;
            }

            @Override
            public QueueProperties toModel(QueueDescription queueDescription) {
                return new QueueProperties(queueDescription);
            }

            @Override
            public void setName(QueueProperties queueProperties, String name) {
                queueProperties.queueName = name;
            }
        });
    }
}

