/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.models.AuthorizationRule;
import com.azure.messaging.servicebus.administration.models.CreateQueueOptions;
import com.azure.messaging.servicebus.administration.models.CreateSubscriptionOptions;
import com.azure.messaging.servicebus.administration.models.CreateTopicOptions;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.RuleAction;
import com.azure.messaging.servicebus.administration.models.RuleFilter;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SharedAccessAuthorizationRule;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.messaging.servicebus.implementation.models.AuthorizationRuleImpl;
import com.azure.messaging.servicebus.implementation.models.QueueDescription;
import com.azure.messaging.servicebus.implementation.models.RuleActionImpl;
import com.azure.messaging.servicebus.implementation.models.RuleDescription;
import com.azure.messaging.servicebus.implementation.models.RuleFilterImpl;
import com.azure.messaging.servicebus.implementation.models.SubscriptionDescription;
import com.azure.messaging.servicebus.implementation.models.TopicDescription;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class EntityHelper {
    private static QueueAccessor queueAccessor;
    private static SubscriptionAccessor subscriptionAccessor;
    private static TopicAccessor topicAccessor;
    private static RuleAccessor ruleAccessor;

    public static QueueDescription getQueueDescription(CreateQueueOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        QueueDescription description = new QueueDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDeadLetteringOnMessageExpiration(options.isDeadLetteringOnMessageExpiration()).setDuplicateDetectionHistoryTimeWindow(options.getDuplicateDetectionHistoryTimeWindow()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setEnablePartitioning(options.isPartitioningEnabled()).setForwardTo(options.getForwardTo()).setForwardDeadLetteredMessagesTo(options.getForwardDeadLetteredMessagesTo()).setLockDuration(options.getLockDuration()).setMaxDeliveryCount(options.getMaxDeliveryCount()).setMaxSizeInMegabytes(options.getMaxSizeInMegabytes()).setRequiresDuplicateDetection(options.isDuplicateDetectionRequired()).setRequiresSession(options.isSessionRequired()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata());
        if (!options.getAuthorizationRules().isEmpty()) {
            description.setAuthorizationRules(EntityHelper.toImplementation(options.getAuthorizationRules()));
        }
        return description;
    }

    public static SubscriptionDescription getSubscriptionDescription(CreateSubscriptionOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        return new SubscriptionDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDeadLetteringOnFilterEvaluationExceptions(options.isDeadLetteringOnFilterEvaluationExceptions()).setDeadLetteringOnMessageExpiration(options.isDeadLetteringOnMessageExpiration()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setForwardTo(options.getForwardTo()).setForwardDeadLetteredMessagesTo(options.getForwardDeadLetteredMessagesTo()).setLockDuration(options.getLockDuration()).setMaxDeliveryCount(options.getMaxDeliveryCount()).setRequiresSession(options.isSessionRequired()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata());
    }

    public static TopicDescription getTopicDescription(CreateTopicOptions options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        TopicDescription description = new TopicDescription().setAutoDeleteOnIdle(options.getAutoDeleteOnIdle()).setDefaultMessageTimeToLive(options.getDefaultMessageTimeToLive()).setDuplicateDetectionHistoryTimeWindow(options.getDuplicateDetectionHistoryTimeWindow()).setEnableBatchedOperations(options.isBatchedOperationsEnabled()).setEnablePartitioning(options.isPartitioningEnabled()).setMaxSizeInMegabytes(options.getMaxSizeInMegabytes()).setRequiresDuplicateDetection(options.isDuplicateDetectionRequired()).setSupportOrdering(options.isSupportOrdering()).setStatus(options.getStatus()).setUserMetadata(options.getUserMetadata());
        if (!options.getAuthorizationRules().isEmpty()) {
            description.setAuthorizationRules(EntityHelper.toImplementation(options.getAuthorizationRules()));
        }
        return description;
    }

    public static QueueDescription toImplementation(QueueProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (queueAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        List<AuthorizationRuleImpl> rules = !properties.getAuthorizationRules().isEmpty() ? EntityHelper.toImplementation(properties.getAuthorizationRules()) : Collections.emptyList();
        return queueAccessor.toImplementation(properties, rules);
    }

    public static RuleActionImpl toImplementation(RuleAction properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static RuleDescription toImplementation(RuleProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static RuleFilterImpl toImplementation(RuleFilter properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (ruleAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toImplementation(properties);
    }

    public static SubscriptionDescription toImplementation(SubscriptionProperties description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (subscriptionAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        return subscriptionAccessor.toImplementation(description);
    }

    public static TopicDescription toImplementation(TopicProperties properties) {
        Objects.requireNonNull(properties, "'properties' cannot be null.");
        if (topicAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        List<AuthorizationRuleImpl> rules = !properties.getAuthorizationRules().isEmpty() ? EntityHelper.toImplementation(properties.getAuthorizationRules()) : Collections.emptyList();
        return topicAccessor.toImplementation(properties, rules);
    }

    public static QueueProperties toModel(QueueDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (queueAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        return queueAccessor.toModel(description);
    }

    public static RuleAction toModel(RuleActionImpl description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static RuleFilter toModel(RuleFilterImpl description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static RuleProperties toModel(RuleDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (ruleAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' should not be null."));
        }
        return ruleAccessor.toModel(description);
    }

    public static SubscriptionProperties toModel(SubscriptionDescription options) {
        Objects.requireNonNull(options, "'options' cannot be null.");
        if (subscriptionAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        return subscriptionAccessor.toModel(options);
    }

    public static TopicProperties toModel(TopicDescription description) {
        Objects.requireNonNull(description, "'description' cannot be null.");
        if (topicAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        return topicAccessor.toModel(description);
    }

    public static void setQueueAccessor(QueueAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (queueAccessor != null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'accessor' is already set."));
        }
        queueAccessor = accessor;
    }

    public static void setQueueName(QueueProperties queueProperties, String name) {
        if (queueAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'queueAccessor' should not be null."));
        }
        queueAccessor.setName(queueProperties, name);
    }

    public static void setRuleAccessor(RuleAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (ruleAccessor != null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'ruleAccessor' is already set."));
        }
        ruleAccessor = accessor;
    }

    public static void setSubscriptionAccessor(SubscriptionAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (subscriptionAccessor != null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' is already set."));
        }
        subscriptionAccessor = accessor;
    }

    public static void setSubscriptionName(SubscriptionProperties subscription, String subscriptionName) {
        if (subscriptionAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        subscriptionAccessor.setSubscriptionName(subscription, subscriptionName);
    }

    public static void setTopicAccessor(TopicAccessor accessor) {
        Objects.requireNonNull(accessor, "'accessor' cannot be null.");
        if (topicAccessor != null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' is already set."));
        }
        topicAccessor = accessor;
    }

    public static void setTopicName(SubscriptionProperties subscription, String topicName) {
        if (subscriptionAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'subscriptionAccessor' should not be null."));
        }
        subscriptionAccessor.setTopicName(subscription, topicName);
    }

    public static void setTopicName(TopicProperties topicProperties, String topicName) {
        if (topicAccessor == null) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException("'topicAccessor' should not be null."));
        }
        topicAccessor.setName(topicProperties, topicName);
    }

    private static List<AuthorizationRuleImpl> toImplementation(List<AuthorizationRule> rules) {
        return rules.stream().map(rule -> {
            AuthorizationRuleImpl implementation = new AuthorizationRuleImpl().setClaimType(rule.getClaimType()).setClaimValue(rule.getClaimValue()).setCreatedTime(rule.getCreatedAt()).setKeyName(rule.getKeyName()).setModifiedTime(rule.getModifiedAt()).setPrimaryKey(rule.getPrimaryKey()).setSecondaryKey(rule.getSecondaryKey()).setRights(rule.getAccessRights());
            if (rule instanceof SharedAccessAuthorizationRule) {
                implementation.setType("SharedAccessAuthorizationRule");
            } else {
                String className = rule.getClass().getName();
                new ClientLogger(EntityHelper.class).warning("AuthorizationRule type '{}' is unknown.", new Object[]{className});
                implementation.setType(className);
            }
            return implementation;
        }).collect(Collectors.toList());
    }

    static {
        try {
            Class.forName(QueueProperties.class.getName(), true, QueueProperties.class.getClassLoader());
            Class.forName(SubscriptionProperties.class.getName(), true, SubscriptionProperties.class.getClassLoader());
            Class.forName(TopicProperties.class.getName(), true, TopicProperties.class.getClassLoader());
            Class.forName(RuleProperties.class.getName(), true, RuleProperties.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new ClientLogger(EntityHelper.class).logExceptionAsError((RuntimeException)new IllegalStateException(e));
        }
    }

    public static interface TopicAccessor {
        public TopicDescription toImplementation(TopicProperties var1, List<AuthorizationRuleImpl> var2);

        public TopicProperties toModel(TopicDescription var1);

        public void setName(TopicProperties var1, String var2);
    }

    public static interface SubscriptionAccessor {
        public SubscriptionProperties toModel(SubscriptionDescription var1);

        public SubscriptionDescription toImplementation(SubscriptionProperties var1);

        public void setTopicName(SubscriptionProperties var1, String var2);

        public void setSubscriptionName(SubscriptionProperties var1, String var2);
    }

    public static interface RuleAccessor {
        public RuleProperties toModel(RuleDescription var1);

        public RuleAction toModel(RuleActionImpl var1);

        public RuleFilter toModel(RuleFilterImpl var1);

        public RuleDescription toImplementation(RuleProperties var1);

        public RuleActionImpl toImplementation(RuleAction var1);

        public RuleFilterImpl toImplementation(RuleFilter var1);
    }

    public static interface QueueAccessor {
        public QueueDescription toImplementation(QueueProperties var1, List<AuthorizationRuleImpl> var2);

        public QueueProperties toModel(QueueDescription var1);

        public void setName(QueueProperties var1, String var2);
    }
}

