/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.amqp.AmqpRetryMode;
import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.implementation.TracerProvider;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.tracing.ProcessKind;
import com.azure.messaging.servicebus.ServiceBusMessage;
import com.azure.messaging.servicebus.ServiceBusTransactionContext;
import com.azure.messaging.servicebus.implementation.DispositionStatus;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Accepted;
import org.apache.qpid.proton.amqp.messaging.Modified;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Rejected;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.DeliveryState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import reactor.core.publisher.Signal;

public final class MessageUtils {
    static final UUID ZERO_LOCK_TOKEN = new UUID(0L, 0L);
    static final int LOCK_TOKEN_SIZE = 16;
    private static final Symbol DEAD_LETTER_OPERATION = Symbol.getSymbol((String)"com.microsoft:dead-letter");
    private static final String DEAD_LETTER_REASON = "DeadLetterReason";
    private static final String DEAD_LETTER_ERROR_DESCRIPTION = "DeadLetterErrorDescription";
    private static final long EPOCH_IN_DOT_NET_TICKS = 621355968000000000L;
    private static final int GUID_SIZE = 16;

    private MessageUtils() {
    }

    public static Duration adjustServerTimeout(Duration clientTimeout) {
        return clientTimeout.minusMillis(1000L);
    }

    public static Duration getTotalTimeout(AmqpRetryOptions retryOptions) {
        long tryTimeout = retryOptions.getTryTimeout().toNanos();
        long maxDelay = retryOptions.getMaxDelay().toNanos();
        long totalTimeout = tryTimeout;
        if (retryOptions.getMode() == AmqpRetryMode.FIXED) {
            totalTimeout += (retryOptions.getDelay().toNanos() + tryTimeout) * (long)retryOptions.getMaxRetries();
        } else {
            int multiplier = 1;
            for (int i = 0; i < retryOptions.getMaxRetries(); ++i) {
                long retryDelay = retryOptions.getDelay().toNanos() * (long)multiplier;
                if (retryDelay >= maxDelay) {
                    retryDelay = maxDelay;
                    totalTimeout += (tryTimeout + retryDelay) * (long)(retryOptions.getMaxRetries() - i);
                    break;
                }
                multiplier *= 2;
                totalTimeout += tryTimeout + retryDelay;
            }
        }
        return Duration.ofNanos(totalTimeout);
    }

    static UUID convertDotNetBytesToUUID(byte[] dotNetBytes) {
        if (dotNetBytes == null || dotNetBytes.length != 16) {
            return ZERO_LOCK_TOKEN;
        }
        byte[] reOrderedBytes = MessageUtils.reorderBytes(dotNetBytes);
        ByteBuffer buffer = ByteBuffer.wrap(reOrderedBytes);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return new UUID(mostSignificantBits, leastSignificantBits);
    }

    static byte[] convertUUIDToDotNetBytes(UUID uuid) {
        if (uuid == null || uuid.equals(ZERO_LOCK_TOKEN)) {
            return new byte[16];
        }
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        byte[] javaBytes = buffer.array();
        return MessageUtils.reorderBytes(javaBytes);
    }

    static OffsetDateTime convertDotNetTicksToOffsetDateTime(long dotNetTicks) {
        long ticksFromEpoch = dotNetTicks - 621355968000000000L;
        long millisecondsFromEpoch = Double.valueOf((double)ticksFromEpoch * 1.0E-4).longValue();
        long fractionTicks = ticksFromEpoch % 10000L;
        return Instant.ofEpochMilli(millisecondsFromEpoch).plusNanos(fractionTicks * 100L).atOffset(ZoneOffset.UTC);
    }

    public static DeliveryState getDeliveryState(DispositionStatus dispositionStatus, String deadLetterReason, String deadLetterErrorDescription, Map<String, Object> propertiesToModify, ServiceBusTransactionContext transactionContext) {
        Accepted state;
        boolean hasTransaction = transactionContext != null && transactionContext.getTransactionId() != null;
        switch (dispositionStatus) {
            case COMPLETED: {
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)Accepted.getInstance());
                    break;
                }
                state = Accepted.getInstance();
                break;
            }
            case SUSPENDED: {
                Rejected rejected = new Rejected();
                ErrorCondition error = new ErrorCondition(DEAD_LETTER_OPERATION, null);
                HashMap<String, Object> errorInfo = new HashMap<String, Object>();
                if (!CoreUtils.isNullOrEmpty((CharSequence)deadLetterReason)) {
                    errorInfo.put(DEAD_LETTER_REASON, deadLetterReason);
                }
                if (!CoreUtils.isNullOrEmpty((CharSequence)deadLetterErrorDescription)) {
                    errorInfo.put(DEAD_LETTER_ERROR_DESCRIPTION, deadLetterErrorDescription);
                }
                if (propertiesToModify != null) {
                    errorInfo.putAll(propertiesToModify);
                }
                error.setInfo(errorInfo);
                rejected.setError(error);
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)rejected);
                    break;
                }
                state = rejected;
                break;
            }
            case ABANDONED: {
                Modified outcome = new Modified();
                if (propertiesToModify != null) {
                    outcome.setMessageAnnotations(propertiesToModify);
                }
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)outcome);
                    break;
                }
                state = outcome;
                break;
            }
            case DEFERRED: {
                Modified deferredOutcome = new Modified();
                deferredOutcome.setUndeliverableHere(Boolean.valueOf(true));
                if (propertiesToModify != null) {
                    deferredOutcome.setMessageAnnotations(propertiesToModify);
                }
                if (hasTransaction) {
                    state = MessageUtils.getTransactionState(transactionContext.getTransactionId(), (Outcome)deferredOutcome);
                    break;
                }
                state = deferredOutcome;
                break;
            }
            default: {
                state = null;
            }
        }
        return state;
    }

    public static boolean toPrimitive(Boolean value) {
        return value != null ? value : false;
    }

    public static int toPrimitive(Integer value) {
        return value != null ? value : 0;
    }

    public static long toPrimitive(Long value) {
        return value != null ? value : 0L;
    }

    private static byte[] reorderBytes(byte[] javaBytes) {
        byte[] reorderedBytes = new byte[16];
        for (int i = 0; i < 16; ++i) {
            switch (i) {
                case 0: {
                    int indexInReorderedBytes = 3;
                    break;
                }
                case 1: {
                    int indexInReorderedBytes = 2;
                    break;
                }
                case 2: {
                    int indexInReorderedBytes = 1;
                    break;
                }
                case 3: {
                    int indexInReorderedBytes = 0;
                    break;
                }
                case 4: {
                    int indexInReorderedBytes = 5;
                    break;
                }
                case 5: {
                    int indexInReorderedBytes = 4;
                    break;
                }
                case 6: {
                    int indexInReorderedBytes = 7;
                    break;
                }
                case 7: {
                    int indexInReorderedBytes = 6;
                    break;
                }
                default: {
                    int indexInReorderedBytes = i;
                }
            }
            reorderedBytes[indexInReorderedBytes] = javaBytes[i];
        }
        return reorderedBytes;
    }

    private static TransactionalState getTransactionState(ByteBuffer transactionId, Outcome outcome) {
        TransactionalState transactionalState = new TransactionalState();
        transactionalState.setTxnId(new Binary(transactionId.array()));
        transactionalState.setOutcome(outcome);
        return transactionalState;
    }

    public static ServiceBusMessage traceMessageSpan(ServiceBusMessage serviceBusMessage, Context messageContext, String hostname, String entityPath, TracerProvider tracerProvider) {
        Optional eventContextData = messageContext.getData((Object)"span-context");
        if (eventContextData.isPresent()) {
            return serviceBusMessage;
        }
        Context newMessageContext = messageContext.addData((Object)"az.namespace", (Object)"Microsoft.ServiceBus").addData((Object)"entity-path", (Object)entityPath).addData((Object)"hostname", (Object)hostname);
        Context eventSpanContext = tracerProvider.startSpan("ServiceBus.", newMessageContext, ProcessKind.MESSAGE);
        Optional eventDiagnosticIdOptional = eventSpanContext.getData((Object)"diagnostic-id");
        if (eventDiagnosticIdOptional.isPresent()) {
            serviceBusMessage.getApplicationProperties().put("diagnostic-id", eventDiagnosticIdOptional.get().toString());
            tracerProvider.endSpan(eventSpanContext, Signal.complete());
            serviceBusMessage.addContext("span-context", eventSpanContext);
        }
        return serviceBusMessage;
    }
}

