/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.implementation.models.NamespacePropertiesEntry;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class NamespacesImpl {
    private final NamespacesService service;
    private final ServiceBusManagementClientImpl client;

    NamespacesImpl(ServiceBusManagementClientImpl client) {
        this.service = (NamespacesService)RestProxy.create(NamespacesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    public Mono<Response<NamespacePropertiesEntry>> getWithResponseAsync(Context context) {
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), context);
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface NamespacesService {
        @Get(value="/$namespaceinfo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<NamespacePropertiesEntry>> get(@HostParam(value="endpoint") String var1, @QueryParam(value="api-version") String var2, Context var3);
    }
}

