/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.administration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.servicebus.administration.models.RuleAction;
import java.util.HashMap;
import java.util.Map;

public class SqlRuleAction
extends RuleAction {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final String sqlExpression;
    private final String compatibilityLevel;
    private final Boolean requiresPreprocessing;

    public SqlRuleAction(String sqlExpression) {
        ClientLogger logger = new ClientLogger(SqlRuleAction.class);
        if (sqlExpression == null) {
            throw logger.logExceptionAsError((RuntimeException)new NullPointerException("'sqlExpression' cannot be null."));
        }
        if (sqlExpression.isEmpty()) {
            throw logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("'sqlExpression' cannot be an empty string."));
        }
        this.sqlExpression = sqlExpression;
        this.compatibilityLevel = null;
        this.requiresPreprocessing = null;
    }

    SqlRuleAction(String sqlExpression, String compatibilityLevel, Boolean requiresPreprocessing) {
        this.sqlExpression = sqlExpression;
        this.compatibilityLevel = compatibilityLevel;
        this.requiresPreprocessing = requiresPreprocessing;
    }

    String getCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    Boolean isPreprocessingRequired() {
        return this.requiresPreprocessing;
    }

    public Map<String, Object> getParameters() {
        return this.properties;
    }

    public String getSqlExpression() {
        return this.sqlExpression;
    }
}

