/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.messaging.servicebus.implementation.ServiceBusManagementClientImpl;
import com.azure.messaging.servicebus.implementation.models.ServiceBusManagementErrorException;
import reactor.core.publisher.Mono;

public final class RulesImpl {
    private final RulesService service;
    private final ServiceBusManagementClientImpl client;

    RulesImpl(ServiceBusManagementClientImpl client) {
        this.service = (RulesService)RestProxy.create(RulesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> getWithResponseAsync(String topicName, String subscriptionName, String ruleName, Boolean enrich, Context context) {
        return this.service.get(this.client.getEndpoint(), topicName, subscriptionName, ruleName, enrich, this.client.getApiVersion(), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> putWithResponseAsync(String topicName, String subscriptionName, String ruleName, Object requestBody, String ifMatch, Context context) {
        return this.service.put(this.client.getEndpoint(), topicName, subscriptionName, ruleName, this.client.getApiVersion(), ifMatch, requestBody, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Object>> deleteWithResponseAsync(String topicName, String subscriptionName, String ruleName, Context context) {
        return this.service.delete(this.client.getEndpoint(), topicName, subscriptionName, ruleName, this.client.getApiVersion(), context);
    }

    @Host(value="https://{endpoint}")
    @ServiceInterface(name="ServiceBusManagement")
    private static interface RulesService {
        @Get(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> get(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="enrich") Boolean var5, @QueryParam(value="api-version") String var6, Context var7);

        @Put(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> put(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="If-Match") String var6, @BodyParam(value="application/atom+xml") Object var7, Context var8);

        @Delete(value="/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ServiceBusManagementErrorException.class)
        public Mono<Response<Object>> delete(@HostParam(value="endpoint") String var1, @PathParam(value="topicName") String var2, @PathParam(value="subscriptionName") String var3, @PathParam(value="ruleName") String var4, @QueryParam(value="api-version") String var5, Context var6);
    }
}

