/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.servicebus;

import com.azure.messaging.servicebus.ServiceBusMessageContext;
import com.azure.messaging.servicebus.ServiceBusReceivedMessage;
import com.azure.messaging.servicebus.ServiceBusReceiverAsyncClient;
import com.azure.messaging.servicebus.models.AbandonOptions;
import com.azure.messaging.servicebus.models.CompleteOptions;
import com.azure.messaging.servicebus.models.DeadLetterOptions;
import com.azure.messaging.servicebus.models.DeferOptions;
import java.util.Objects;

public final class ServiceBusReceivedMessageContext {
    private final ServiceBusMessageContext receivedMessageContext;
    private final ServiceBusReceiverAsyncClient receiverClient;

    ServiceBusReceivedMessageContext(ServiceBusReceiverAsyncClient receiverClient, ServiceBusMessageContext receivedMessageContext) {
        this.receivedMessageContext = Objects.requireNonNull(receivedMessageContext, "'receivedMessageContext' cannot be null");
        this.receiverClient = Objects.requireNonNull(receiverClient, "'receiverClient' cannot be null");
    }

    public ServiceBusReceivedMessage getMessage() {
        return this.receivedMessageContext.getMessage();
    }

    public void abandon() {
        this.receiverClient.abandon(this.receivedMessageContext.getMessage()).block();
    }

    public void abandon(AbandonOptions options) {
        this.receiverClient.abandon(this.receivedMessageContext.getMessage(), options).block();
    }

    public void complete() {
        this.receiverClient.complete(this.receivedMessageContext.getMessage()).block();
    }

    public void complete(CompleteOptions options) {
        this.receiverClient.complete(this.receivedMessageContext.getMessage(), options).block();
    }

    public void defer() {
        this.receiverClient.defer(this.receivedMessageContext.getMessage()).block();
    }

    public void defer(DeferOptions options) {
        this.receiverClient.defer(this.receivedMessageContext.getMessage(), options).block();
    }

    public void deadLetter() {
        this.receiverClient.deadLetter(this.receivedMessageContext.getMessage()).block();
    }

    public void deadLetter(DeadLetterOptions options) {
        this.receiverClient.deadLetter(this.receivedMessageContext.getMessage(), options).block();
    }
}

