/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.aop;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.dynamic.datasource.support.DataSourceClassResolver;
import com.baomidou.dynamic.datasource.tx.TransactionalExecutor;
import com.baomidou.dynamic.datasource.tx.TransactionalInfo;
import com.baomidou.dynamic.datasource.tx.TransactionalTemplate;
import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicLocalTransactionInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicLocalTransactionInterceptor.class);
    private final TransactionalTemplate transactionalTemplate = new TransactionalTemplate();
    private final DataSourceClassResolver dataSourceClassResolver;

    public DynamicLocalTransactionInterceptor(Boolean allowedPublicOnly) {
        this.dataSourceClassResolver = new DataSourceClassResolver(allowedPublicOnly);
    }

    public Object invoke(final MethodInvocation methodInvocation) throws Throwable {
        final Method method = methodInvocation.getMethod();
        TransactionalExecutor transactionalExecutor = new TransactionalExecutor(){

            @Override
            public Object execute() throws Throwable {
                return methodInvocation.proceed();
            }

            @Override
            public TransactionalInfo getTransactionInfo() {
                return DynamicLocalTransactionInterceptor.this.dataSourceClassResolver.findTransactionalInfo(method, methodInvocation.getThis(), DSTransactional.class);
            }
        };
        return this.transactionalTemplate.execute(transactionalExecutor);
    }
}

