/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.support;

import com.baomidou.dynamic.datasource.toolkit.DsStrUtils;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;

public class ScriptRunner {
    private static final Logger log = LoggerFactory.getLogger(ScriptRunner.class);
    private final boolean continueOnError;
    private final String separator;

    public void runScript(DataSource dataSource, String location) {
        if (DsStrUtils.hasText((CharSequence)location)) {
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            populator.setContinueOnError(this.continueOnError);
            populator.setSeparator(this.separator);
            try {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
                populator.addScripts(resolver.getResources(location));
                DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)dataSource);
            }
            catch (DataAccessException e) {
                log.warn("execute sql error", (Throwable)e);
            }
            catch (Exception e1) {
                log.warn("failed to initialize dataSource from schema file {} ", (Object)location, (Object)e1);
            }
        }
    }

    public ScriptRunner(boolean continueOnError, String separator) {
        this.continueOnError = continueOnError;
        this.separator = separator;
    }
}

