/*
 * Decompiled with CFR 0.152.
 */
package com.codingapi.tx.datasource.aspect;

import com.codingapi.tx.datasource.ILCNConnection;
import java.sql.Connection;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DataSourceAspect {
    private Logger logger = LoggerFactory.getLogger(DataSourceAspect.class);
    @Autowired
    private ILCNConnection lcnConnection;

    @Around(value="execution(* javax.sql.DataSource.getConnection(..))")
    public Connection around(ProceedingJoinPoint point) throws Throwable {
        this.logger.debug("getConnection-start---->");
        Connection connection = this.lcnConnection.getConnection(point);
        this.logger.debug("connection-->" + connection);
        this.logger.debug("getConnection-end---->");
        return connection;
    }
}

