/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.b.d;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbType;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.MathUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public class DmdbTimestamp
extends Timestamp
implements Serializable {
    private static final long serialVersionUID = 544720274538766252L;
    public static final long MiSeconds_1900_1970 = 2209017600000L;
    public static final int OFFSET_YEAR = 0;
    public static final int OFFSET_MONTH = 1;
    public static final int OFFSET_DAY = 2;
    public static final int OFFSET_HOUR = 3;
    public static final int OFFSET_MINUTE = 4;
    public static final int OFFSET_SECOND = 5;
    public static final int OFFSET_MICROSECOND = 6;
    public static final int OFFSET_TIMEZONE = 7;
    public static final int DT_LEN = 8;
    public static final int INVALID_VALUE = Integer.MIN_VALUE;
    public int[] kN;
    public int kO = 16;
    public int scale = 6;
    private String kP;
    private int gM;

    public DmdbTimestamp(int[] nArray, int n2, int n3) {
        super(DateUtil.toTimeInMillis(nArray));
        this.kN = nArray;
        this.kO = n2;
        this.scale = n3;
        this.setNanos(this.getNanos());
    }

    public DmdbTimestamp(byte[] byArray, d d2, DmdbConnection dmdbConnection) {
        this(DateUtil.decode(byArray, d2.ax, d2.type, d2.scale, dmdbConnection.connection_property_localTimezone, dmdbConnection.gs), d2.type, DmdbType.isLocalTimeZone(d2.type, d2.scale) ? DmdbType.getLocalTimeZoneScale(d2.type, d2.scale) : d2.scale);
        this.gM = dmdbConnection.gM;
        switch (d2.type) {
            case 14: {
                this.kP = dmdbConnection.gN;
                break;
            }
            case 15: {
                this.kP = dmdbConnection.gQ;
                break;
            }
            case 22: {
                this.kP = dmdbConnection.gR;
                break;
            }
            case 16: {
                this.kP = dmdbConnection.gO;
                break;
            }
            case 23: {
                this.kP = dmdbConnection.gP;
                break;
            }
        }
    }

    @Override
    public long getTime() {
        return DateUtil.toTimeInMillis(this.kN, null);
    }

    @Override
    public void setTime(long l2) {
        super.setTime(l2);
        this.kN = DateUtil.toDT(l2, null);
    }

    @Override
    public int getNanos() {
        return this.kN[6] * 1000;
    }

    @Override
    public void setNanos(int n2) {
        super.setNanos(n2);
        this.kN[6] = n2 / 1000;
    }

    @Override
    public int compareTo(DmdbTimestamp dmdbTimestamp) {
        int n2;
        int[] nArray = dmdbTimestamp.kN;
        if (this.getTimezone() != dmdbTimestamp.getTimezone()) {
            nArray = Arrays.copyOf(nArray, nArray.length);
            DateUtil.transformTZ(nArray, this.kN[7], nArray[7]);
        }
        return (n2 = MathUtil.compare(DateUtil.toTimeInMillis(this.kN), DateUtil.toTimeInMillis(nArray))) != 0 ? n2 : MathUtil.compare(this.kN[6], nArray[6]);
    }

    public static DmdbTimestamp valueOf(String string) {
        int n2;
        int[] nArray;
        return new DmdbTimestamp(nArray, n2, (n2 = DateUtil.toDT(string, nArray = new int[8])) == 14 ? 0 : 6);
    }

    public static DmdbTimestamp valueOf(Date date) {
        int[] nArray = DateUtil.toDT(date.getTime(), Calendar.getInstance());
        return new DmdbTimestamp(nArray, 16, 6);
    }

    public java.sql.Date toDate() {
        return DateUtil.toDate(this.kN, null);
    }

    public Time toTime() {
        return DateUtil.toTime(this.kN, null);
    }

    public Timestamp toTimestamp() {
        return DateUtil.toTimestamp(this.kN, null);
    }

    public byte[] toBytes() {
        return DateUtil.encode(this.kN, this.kO, this.scale, this.getTimezone());
    }

    public int[] getDt() {
        return this.kN;
    }

    public int getTimezone() {
        return this.kN[7];
    }

    public void setTimezone(int n2) {
        if (n2 <= -780 || n2 > 840) {
            DBError.ECJDBC_INVALID_DATETIME_FORMAT.throwException(new String[0]);
        }
        this.kN[7] = n2;
    }

    @Override
    public String toString() {
        if (StringUtil.isNotEmpty(this.kP)) {
            return DateUtil.toString(this.kN, this.kP, this.gM);
        }
        return DateUtil.toString(this.kN, this.kO, this.scale);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DmdbTimestamp)) {
            return false;
        }
        DmdbTimestamp dmdbTimestamp = (DmdbTimestamp)object;
        return dmdbTimestamp.kO == this.kO && dmdbTimestamp.scale == this.scale && Arrays.equals(this.kN, dmdbTimestamp.kN);
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.kO;
        n2 = 31 * n2 + this.scale;
        n2 = 31 * n2 + Arrays.hashCode(this.kN);
        return n2;
    }

    public static void main(String[] stringArray) {
        DmdbTimestamp dmdbTimestamp;
        DmdbTimestamp dmdbTimestamp2 = dmdbTimestamp = DmdbTimestamp.valueOf("2018-09-07 16:09:13.123456");
        System.out.println(dmdbTimestamp2);
    }

    public static /* bridge */ /* synthetic */ Timestamp valueOf(String string) {
        return DmdbTimestamp.valueOf(string);
    }
}

