/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.filter.log;

import dm.jdbc.b.a;
import dm.jdbc.b.i;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbDatabaseMetaData;
import dm.jdbc.driver.DmdbParameterMetaData;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbResultSetMetaData;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.filter.log.ILogger;
import dm.jdbc.filter.log.LogRecord$NullData;
import dm.jdbc.filter.log.LogWriter;
import dm.jdbc.util.DateUtil;
import dm.jdbc.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;

public class Logger
implements ILogger {
    public Logger(String string) {
    }

    @Override
    public boolean isDebugEnabled() {
        return i.eo >= 5;
    }

    @Override
    public boolean isErrorEnabled() {
        return i.eo >= 1;
    }

    @Override
    public boolean isInfoEnabled() {
        return i.eo >= 4;
    }

    @Override
    public boolean isWarnEnabled() {
        return i.eo >= 2;
    }

    @Override
    public boolean isSqlEnabled() {
        return i.eo >= 3;
    }

    @Override
    public void debug(String string) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + string);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void debug(String string, Throwable throwable) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + string + StringUtil.LINE_SEPARATOR + Logger.getStackTrace(throwable));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void debug(Object object, String string, Object ... objectArray) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + Logger.formatTrace(object, string, objectArray));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void debug(Object object, String string, String string2) {
        try {
            if (this.isDebugEnabled()) {
                this.println(String.valueOf(this.formatHead("DEBUG")) + Logger.formatTrace(object, string, string2));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void info(String string) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + string.toString());
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void info(Object object, String string, String string2) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + Logger.formatTrace(object, string, string2));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void info(Object object, String string, Object ... objectArray) {
        try {
            if (this.isInfoEnabled()) {
                this.println(String.valueOf(this.formatHead("INFO ")) + Logger.formatTrace(object, string, objectArray));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void sql(String string) {
        try {
            if (this.isSqlEnabled()) {
                this.println(String.valueOf(this.formatHead("SQL  ")) + string);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void warn(String string) {
        try {
            if (this.isWarnEnabled()) {
                this.println(String.valueOf(this.formatHead("WARN ")) + string);
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void warn(Object object, String string, String string2) {
        try {
            if (this.isWarnEnabled()) {
                this.println(String.valueOf(this.formatHead("WARN ")) + Logger.formatTrace(object, string, string2));
            }
        }
        catch (Exception exception) {}
    }

    @Override
    public void error(String string) {
        this.error(string, null);
    }

    @Override
    public void error(String string, Throwable throwable) {
        try {
            if (this.isErrorEnabled()) {
                this.println(String.valueOf(this.formatHead("ERROR")) + string + StringUtil.LINE_SEPARATOR + Logger.getStackTrace(throwable));
            }
        }
        catch (Exception exception) {}
    }

    private String formatHead(String string) {
        return "[" + string + " - " + DateUtil.formatDate(new Date(System.currentTimeMillis()), 2) + "] tid:" + Thread.currentThread().getId();
    }

    private void println(String string) {
        LogWriter.getInstance().writeLine(StringUtil.trimToEmpty(string));
    }

    public static String getStackTrace(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        StringWriter stringWriter = new StringWriter(256);
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return String.valueOf(stringWriter.toString()) + StringUtil.LINE_SEPARATOR;
    }

    public static String formatTrace(Object object, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object != null) {
            stringBuilder.append("{ " + Logger.formatSource(object) + " } ");
        }
        stringBuilder.append(string).append("();  ");
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }

    public static String formatTrace(Object object, String string, Object ... objectArray) {
        return Logger.formatTrace(object, string, null, objectArray);
    }

    public static String formatTrace(Object object, String string, Object object2, Object ... objectArray) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder(128);
        if (object != null) {
            stringBuilder.append("{ " + Logger.formatSource(object) + " } ");
        }
        stringBuilder.append(String.valueOf(string) + "(");
        int n3 = 0;
        if (objectArray != null && objectArray.length > n3) {
            n2 = n3;
            while (n2 < objectArray.length) {
                if (n2 != n3) {
                    stringBuilder.append(", ");
                }
                if (objectArray[n2] != null) {
                    stringBuilder.append(objectArray[n2].getClass().getSimpleName());
                } else {
                    stringBuilder.append("null");
                }
                ++n2;
            }
        }
        stringBuilder.append(")");
        if (object2 != null) {
            stringBuilder.append(": " + Logger.formatReturn(object2));
        }
        stringBuilder.append(";  ");
        if (objectArray != null && objectArray.length > n3) {
            stringBuilder.append("[PARAMS]: ");
            n2 = n3;
            while (n2 < objectArray.length) {
                if (n2 != 0) {
                    stringBuilder.append(", ");
                }
                if (objectArray[n2] instanceof String) {
                    stringBuilder.append("\"").append(objectArray[n2]).append("\"");
                } else {
                    stringBuilder.append(objectArray[n2]);
                }
                ++n2;
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.toString();
    }

    public static String formatSource(Object object) {
        if (object != null) {
            StringBuffer stringBuffer = new StringBuffer(128);
            if (object instanceof String) {
                stringBuffer.append(object);
            } else if (object instanceof DmdbConnection) {
                stringBuffer.append(Logger.formatConn((DmdbConnection)object));
            } else if (object instanceof DmdbStatement) {
                stringBuffer.append(Logger.formatConn(((DmdbStatement)object).K)).append(", ");
                stringBuffer.append(Logger.formatStmt((DmdbStatement)object));
            } else if (object instanceof DmdbResultSet) {
                stringBuffer.append(Logger.formatConn(((DmdbResultSet)object).K)).append(", ");
                stringBuffer.append(Logger.formatStmt(((DmdbResultSet)object).iC)).append(", ");
                stringBuffer.append(Logger.formatRs((DmdbResultSet)object));
            } else if (object instanceof DmdbDatabaseMetaData) {
                stringBuffer.append(Logger.formatConn(((DmdbDatabaseMetaData)object).K)).append(", ");
                stringBuffer.append(((DmdbDatabaseMetaData)object).logInfo != null ? "dbmd-" + ((DmdbDatabaseMetaData)object).getID() : "dbmd-null");
            } else if (object instanceof DmdbResultSetMetaData) {
                stringBuffer.append(((DmdbResultSetMetaData)object).logInfo != null ? "rsmd-" + ((DmdbResultSetMetaData)object).getID() : "rsmd-null");
            } else if (object instanceof DmdbParameterMetaData) {
                stringBuffer.append(((DmdbParameterMetaData)object).logInfo != null ? "pmd-" + ((DmdbParameterMetaData)object).getID() : "pmd-null");
            } else if (object instanceof a) {
                stringBuffer.append(Logger.formatConn(((a)object).K)).append(", ");
                stringBuffer.append(String.valueOf(object.getClass().getSimpleName()) + "@" + Integer.toHexString(object.hashCode()));
            } else {
                stringBuffer.append(String.valueOf(object.getClass().getSimpleName()) + "@" + Integer.toHexString(object.hashCode()));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static String formatReturn(Object object) {
        String string = "";
        if (object instanceof DmdbConnection) {
            string = Logger.formatConn((DmdbConnection)object);
            long l2 = ((DmdbConnection)object).gS;
            string = String.valueOf(string) + (l2 != -1L ? ", sessionID-0x" + Long.toHexString(((DmdbConnection)object).gS) : "");
        } else if (object instanceof DmdbStatement) {
            string = Logger.formatStmt((DmdbStatement)object);
            string = String.valueOf(string) + ", handle-" + ((DmdbStatement)object).fo;
        } else {
            string = object instanceof DmdbResultSet ? Logger.formatRs((DmdbResultSet)object) : (object instanceof DmdbDatabaseMetaData ? (((DmdbDatabaseMetaData)object).logInfo != null ? "dbmd-" + ((DmdbDatabaseMetaData)object).getID() : "dbmd-null") : (object instanceof DmdbResultSetMetaData ? (((DmdbResultSetMetaData)object).logInfo != null ? "rsmd-" + ((DmdbResultSetMetaData)object).getID() : "rsmd-null") : (object instanceof DmdbParameterMetaData ? (((DmdbParameterMetaData)object).logInfo != null ? "pmd-" + ((DmdbParameterMetaData)object).getID() : "pmd-null") : (object instanceof String ? "\"" + object.toString() + "\"" : (object instanceof LogRecord$NullData ? "null" : object.toString())))));
        }
        return string;
    }

    public static String formatConn(DmdbConnection dmdbConnection) {
        if (dmdbConnection != null && dmdbConnection.logInfo != null) {
            return "conn-" + dmdbConnection.getID();
        }
        return "conn-null";
    }

    public static String formatStmt(DmdbStatement dmdbStatement) {
        if (dmdbStatement != null && dmdbStatement.logInfo != null) {
            if (dmdbStatement instanceof DmdbCallableStatement) {
                return "cstmt-" + dmdbStatement.getID();
            }
            if (dmdbStatement instanceof DmdbPreparedStatement) {
                return "pstmt-" + dmdbStatement.getID();
            }
            return "stmt-" + dmdbStatement.getID();
        }
        return "stmt-null";
    }

    public static String formatRs(DmdbResultSet dmdbResultSet) {
        if (dmdbResultSet != null && dmdbResultSet.logInfo != null) {
            return "rs-" + dmdbResultSet.getID();
        }
        return "rs-null";
    }
}

