/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.data;

import com.deepoove.poi.data.PictureType;
import com.deepoove.poi.data.RenderData;
import com.deepoove.poi.data.style.PictureStyle;
import com.deepoove.poi.util.BufferedImageUtils;
import com.deepoove.poi.util.ByteUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.function.Supplier;

public class PictureRenderData
implements RenderData {
    private static final long serialVersionUID = 1L;
    private Supplier<byte[]> pictureSupplier;
    private PictureType pictureType;
    private PictureStyle pictureStyle;
    private String altMeta = "";

    PictureRenderData() {
    }

    public PictureRenderData(int width, int height, String path) {
        this(width, height, new File(path));
    }

    public PictureRenderData(int width, int height, File picture) {
        this(width, height, PictureType.suggestFileType(picture.getPath()), () -> ByteUtils.getLocalByteArray(picture));
    }

    public PictureRenderData(int width, int height, PictureType pictureType, InputStream inputStream) {
        this(width, height, pictureType, ByteUtils.toByteArray(inputStream));
    }

    public PictureRenderData(int width, int height, PictureType pictureType, BufferedImage image) {
        this(width, height, pictureType, () -> BufferedImageUtils.getBufferByteArray(image, pictureType.format()));
    }

    public PictureRenderData(int width, int height, PictureType pictureType, byte[] data) {
        this.pictureStyle = new PictureStyle();
        this.pictureStyle.setWidth(width);
        this.pictureStyle.setHeight(height);
        this.pictureType = pictureType;
        this.pictureSupplier = () -> data;
    }

    public PictureRenderData(int width, int height, PictureType pictureType, Supplier<byte[]> supplier) {
        this.pictureStyle = new PictureStyle();
        this.pictureStyle.setWidth(width);
        this.pictureStyle.setHeight(height);
        this.pictureType = pictureType;
        this.pictureSupplier = supplier;
    }

    public PictureStyle getPictureStyle() {
        return this.pictureStyle;
    }

    public void setPictureStyle(PictureStyle pictureStyle) {
        this.pictureStyle = pictureStyle;
    }

    public Supplier<byte[]> getPictureSupplier() {
        return this.pictureSupplier;
    }

    public void setPictureSupplier(Supplier<byte[]> pictureSupplier) {
        this.pictureSupplier = pictureSupplier;
    }

    public String getAltMeta() {
        return this.altMeta;
    }

    public void setAltMeta(String altMeta) {
        this.altMeta = altMeta;
    }

    public PictureType getPictureType() {
        return this.pictureType;
    }

    public void setPictureType(PictureType pictureType) {
        this.pictureType = pictureType;
    }
}

