/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util.http.okhttp;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.chanjar.weixin.common.bean.result.WxError;
import me.chanjar.weixin.common.exception.WxErrorException;
import me.chanjar.weixin.common.util.fs.FileUtils;
import me.chanjar.weixin.common.util.http.MediaDownloadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.okhttp.OkHttpProxyInfo;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.apache.commons.lang3.StringUtils;

public class OkHttpMediaDownloadRequestExecutor
extends MediaDownloadRequestExecutor<ConnectionPool, OkHttpProxyInfo> {
    public OkHttpMediaDownloadRequestExecutor(RequestHttp requestHttp, File tmpDirFile) {
        super(requestHttp, tmpDirFile);
    }

    @Override
    public File execute(String uri, String queryParam) throws WxErrorException, IOException {
        if (queryParam != null) {
            if (uri.indexOf(63) == -1) {
                uri = uri + '?';
            }
            uri = uri + (uri.endsWith("?") ? queryParam : '&' + queryParam);
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().connectionPool((ConnectionPool)this.requestHttp.getRequestHttpClient());
        if (this.requestHttp.getRequestHttpProxy() != null) {
            clientBuilder.proxy(((OkHttpProxyInfo)this.requestHttp.getRequestHttpProxy()).getProxy());
        }
        clientBuilder.authenticator(new Authenticator(){

            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic((String)((OkHttpProxyInfo)OkHttpMediaDownloadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyUsername(), (String)((OkHttpProxyInfo)OkHttpMediaDownloadRequestExecutor.this.requestHttp.getRequestHttpProxy()).getProxyPassword());
                return response.request().newBuilder().header("Authorization", credential).build();
            }
        });
        OkHttpClient client = clientBuilder.build();
        Request request = new Request.Builder().url(uri).get().build();
        Response response = client.newCall(request).execute();
        String contentType = response.header("Content-Type");
        if (contentType != null && contentType.startsWith("application/json")) {
            throw new WxErrorException(WxError.fromJson(response.body().string()));
        }
        String fileName = this.getFileName(response);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return null;
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(response.body().bytes());
        String[] nameAndExt = fileName.split("\\.");
        return FileUtils.createTmpFile(inputStream, nameAndExt[0], nameAndExt[1], this.tmpDirFile);
    }

    private String getFileName(Response response) throws WxErrorException {
        String content = response.header("Content-disposition");
        if (content == null || content.length() == 0) {
            throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
        }
        Pattern p = Pattern.compile(".*filename=\"(.*)\"");
        Matcher m = p.matcher(content);
        if (m.matches()) {
            return m.group(1);
        }
        throw new WxErrorException(WxError.newBuilder().setErrorMsg("\u65e0\u6cd5\u83b7\u53d6\u5230\u6587\u4ef6\u540d").build());
    }
}

