/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.miniapp.configuration.services;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceHttpClientImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceJoddHttpImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaServiceOkHttpImpl;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.config.impl.WxMaDefaultConfigImpl;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaMultiProperties;
import com.binarywang.spring.starter.wxjava.miniapp.properties.WxMaSingleProperties;
import com.binarywang.spring.starter.wxjava.miniapp.service.WxMaMultiServices;
import com.binarywang.spring.starter.wxjava.miniapp.service.WxMaMultiServicesImpl;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWxMaConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AbstractWxMaConfiguration.class);

    protected WxMaMultiServices wxMaMultiServices(WxMaMultiProperties wxMaMultiProperties) {
        boolean multi;
        Map<String, WxMaSingleProperties> appsMap = wxMaMultiProperties.getApps();
        if (appsMap == null || appsMap.isEmpty()) {
            log.warn("\u5fae\u4fe1\u516c\u4f17\u53f7\u5e94\u7528\u53c2\u6570\u672a\u914d\u7f6e\uff0c\u901a\u8fc7 WxMaMultiServices#getWxMaService(\"tenantId\")\u83b7\u53d6\u5b9e\u4f8b\u5c06\u8fd4\u56de\u7a7a");
            return new WxMaMultiServicesImpl();
        }
        Collection<WxMaSingleProperties> apps = appsMap.values();
        if (apps.size() > 1 && (multi = apps.stream().collect(Collectors.groupingBy(c -> c.getAppId() == null ? Integer.valueOf(0) : c.getAppId(), Collectors.counting())).entrySet().stream().anyMatch(e -> (Long)e.getValue() > 1L))) {
            throw new RuntimeException("\u8bf7\u786e\u4fdd\u5fae\u4fe1\u516c\u4f17\u53f7\u914d\u7f6e appId \u7684\u552f\u4e00\u6027");
        }
        WxMaMultiServicesImpl services = new WxMaMultiServicesImpl();
        Set<Map.Entry<String, WxMaSingleProperties>> entries = appsMap.entrySet();
        for (Map.Entry<String, WxMaSingleProperties> entry : entries) {
            String tenantId = entry.getKey();
            WxMaSingleProperties wxMaSingleProperties = entry.getValue();
            WxMaDefaultConfigImpl storage = this.wxMaConfigStorage(wxMaMultiProperties);
            this.configApp(storage, wxMaSingleProperties);
            this.configHttp(storage, wxMaMultiProperties.getConfigStorage());
            WxMaService wxMaService = this.wxMaService((WxMaConfig)storage, wxMaMultiProperties);
            services.addWxMaService(tenantId, wxMaService);
        }
        return services;
    }

    protected abstract WxMaDefaultConfigImpl wxMaConfigStorage(WxMaMultiProperties var1);

    public WxMaService wxMaService(WxMaConfig wxMaConfig, WxMaMultiProperties wxMaMultiProperties) {
        int retrySleepMillis;
        WxMaServiceOkHttpImpl wxMaService;
        WxMaMultiProperties.ConfigStorage storage = wxMaMultiProperties.getConfigStorage();
        WxMaMultiProperties.HttpClientType httpClientType = storage.getHttpClientType();
        switch (httpClientType) {
            case OK_HTTP: {
                wxMaService = new WxMaServiceOkHttpImpl();
                break;
            }
            case JODD_HTTP: {
                wxMaService = new WxMaServiceJoddHttpImpl();
                break;
            }
            case HTTP_CLIENT: {
                wxMaService = new WxMaServiceHttpClientImpl();
                break;
            }
            default: {
                wxMaService = new WxMaServiceImpl();
            }
        }
        wxMaService.setWxMaConfig(wxMaConfig);
        int maxRetryTimes = storage.getMaxRetryTimes();
        if (maxRetryTimes < 0) {
            maxRetryTimes = 0;
        }
        if ((retrySleepMillis = storage.getRetrySleepMillis()) < 0) {
            retrySleepMillis = 1000;
        }
        wxMaService.setRetrySleepMillis(retrySleepMillis);
        wxMaService.setMaxRetryTimes(maxRetryTimes);
        return wxMaService;
    }

    private void configApp(WxMaDefaultConfigImpl config, WxMaSingleProperties corpProperties) {
        String appId = corpProperties.getAppId();
        String appSecret = corpProperties.getAppSecret();
        String token = corpProperties.getToken();
        String aesKey = corpProperties.getAesKey();
        boolean useStableAccessToken = corpProperties.isUseStableAccessToken();
        config.setAppid(appId);
        config.setSecret(appSecret);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            config.setToken(token);
        }
        if (StringUtils.isNotBlank((CharSequence)aesKey)) {
            config.setAesKey(aesKey);
        }
        config.useStableAccessToken(useStableAccessToken);
    }

    private void configHttp(WxMaDefaultConfigImpl config, WxMaMultiProperties.ConfigStorage storage) {
        String httpProxyHost = storage.getHttpProxyHost();
        Integer httpProxyPort = storage.getHttpProxyPort();
        String httpProxyUsername = storage.getHttpProxyUsername();
        String httpProxyPassword = storage.getHttpProxyPassword();
        if (StringUtils.isNotBlank((CharSequence)httpProxyHost)) {
            config.setHttpProxyHost(httpProxyHost);
            if (httpProxyPort != null) {
                config.setHttpProxyPort(httpProxyPort.intValue());
            }
            if (StringUtils.isNotBlank((CharSequence)httpProxyUsername)) {
                config.setHttpProxyUsername(httpProxyUsername);
            }
            if (StringUtils.isNotBlank((CharSequence)httpProxyPassword)) {
                config.setHttpProxyPassword(httpProxyPassword);
            }
        }
    }
}

