/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.auth;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.AuthenticationHandlerFactory;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.RejectException;

public class MultipleAuthenticationHandlerFactory
implements AuthenticationHandlerFactory {
    final Map<String, AuthenticationHandlerFactory> plugins = new HashMap<String, AuthenticationHandlerFactory>();
    List<String> mechanisms = new ArrayList<String>();

    public MultipleAuthenticationHandlerFactory() {
    }

    public MultipleAuthenticationHandlerFactory(Collection<AuthenticationHandlerFactory> factories) {
        for (AuthenticationHandlerFactory fact : factories) {
            this.addFactory(fact);
        }
    }

    public void addFactory(AuthenticationHandlerFactory fact) {
        List<String> partialMechanisms = fact.getAuthenticationMechanisms();
        for (String mechanism : partialMechanisms) {
            if (this.mechanisms.contains(mechanism)) continue;
            this.mechanisms.add(mechanism);
            this.plugins.put(mechanism, fact);
        }
    }

    @Override
    public List<String> getAuthenticationMechanisms() {
        return this.mechanisms;
    }

    @Override
    public AuthenticationHandler create() {
        return new Handler();
    }

    final class Handler
    implements AuthenticationHandler {
        AuthenticationHandler active;

        Handler() {
        }

        @Override
        public Optional<String> auth(String clientInput, MessageContext context) throws RejectException {
            if (this.active == null) {
                StringTokenizer stk = new StringTokenizer(clientInput);
                String auth = stk.nextToken();
                if (!"AUTH".equalsIgnoreCase(auth)) {
                    throw new IllegalArgumentException("Not an AUTH command: " + clientInput);
                }
                String method = stk.nextToken();
                AuthenticationHandlerFactory fact = MultipleAuthenticationHandlerFactory.this.plugins.get(method.toUpperCase(Locale.ENGLISH));
                if (fact == null) {
                    throw new RejectException(504, "Method not supported");
                }
                this.active = fact.create();
            }
            return this.active.auth(clientInput, context);
        }

        @Override
        public Object getIdentity() {
            return this.active.getIdentity();
        }
    }
}

